/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.backup.DatabaseTable;
import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import liquibase.change.custom.CustomSqlChange;
import liquibase.change.custom.CustomSqlRollback;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.core.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateRepositoryHooksChange
extends AbstractCustomChange
implements CustomSqlChange,
CustomSqlRollback {
    private static final String CONFIGURED_HOOK_STATUS = "sta_configured_hook_status";
    private static final String REPO_HOOK = DatabaseTable.STA_REPO_HOOK.getTableName();
    private static final String REPO_SETTINGS = "sta_repo_settings";
    private static final Logger log = LoggerFactory.getLogger(PopulateRepositoryHooksChange.class);

    public SqlStatement[] generateRollbackStatements(Database database) {
        return new SqlStatement[]{new DeleteStatement(database.getDefaultCatalogName(), database.getDefaultSchemaName(), REPO_HOOK)};
    }

    public SqlStatement[] generateStatements(Database database) {
        String hookKeyColumn = "hookkey";
        String idColumn = "id";
        String repoIdColumn = "repo_id";
        StringBuilder builder = new StringBuilder(384).append("INSERT INTO ").append(REPO_HOOK).append(" (id, repository_id, hook_key, is_enabled, lob_id)").append(" (SELECT ").append("cs.").append(idColumn).append(", cs.").append(repoIdColumn).append(", cs.").append(hookKeyColumn).append(", cs.").append(database.escapeObjectName("enabled", Column.class)).append(", rs.").append(idColumn).append(" FROM ").append(CONFIGURED_HOOK_STATUS).append(" cs").append(" LEFT OUTER JOIN ").append(REPO_SETTINGS).append(" rs").append(" ON cs.").append(repoIdColumn).append(" = rs.").append(repoIdColumn).append(" AND cs.").append(hookKeyColumn).append(" = rs.setting_key)");
        log.debug("Generated SQL: {}", (Object)builder);
        return new SqlStatement[]{new RawSqlStatement(builder.toString())};
    }

    public String getConfirmationMessage() {
        return "Populated " + REPO_HOOK + " from sta_configured_hook_status and sta_repo_settings";
    }
}

