/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase.database;

import com.atlassian.stash.internal.liquibase.database.ExtendedScopeManager;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.ScopeManager;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.AbstractChangeExecListener;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import liquibase.resource.ResourceAccessor;
import liquibase.ui.ConsoleUIService;
import org.apache.commons.io.output.NullPrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedSpringLiquibase
extends SpringLiquibase {
    private static final Logger log = LoggerFactory.getLogger(ExtendedSpringLiquibase.class);
    private static final AtomicReference<ExtendedScopeManager> sessionManager = new AtomicReference<ExtendedScopeManager>(new ExtendedScopeManager());
    private ChangeExecListener changeExecListener = new UpgradeChangeExecListener();

    public ExtendedSpringLiquibase(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public void afterPropertiesSet() throws LiquibaseException {
        Scope.setScopeManager((ScopeManager)sessionManager.get());
        ConsoleUIService uiService = new ConsoleUIService();
        uiService.setErrorStream((PrintStream)NullPrintStream.NULL_PRINT_STREAM);
        uiService.setOutputStream((PrintStream)NullPrintStream.NULL_PRINT_STREAM);
        try {
            String scope = Scope.enter((Map)ImmutableMap.of((Object)Scope.Attr.ui.name(), (Object)uiService));
            try (Connection c = this.getDataSource().getConnection();){
                Liquibase liquibase = this.createLiquibase(c);
                liquibase.setChangeExecListener(this.changeExecListener);
                if (this.changeExecListener instanceof UpgradeChangeExecListener) {
                    ((UpgradeChangeExecListener)this.changeExecListener).beforeUpgrade();
                }
                this.performUpdate(liquibase);
                if (this.changeExecListener instanceof UpgradeChangeExecListener) {
                    ((UpgradeChangeExecListener)this.changeExecListener).afterUpgrade();
                }
            }
            catch (SQLException e) {
                throw new DatabaseException((Throwable)e);
            }
            finally {
                Scope.exit((String)scope);
            }
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, LiquibaseException.class);
            throw new LiquibaseException("Could not update scope", (Throwable)e);
        }
    }

    public void setChangeExecListener(ChangeExecListener changeExecListener) {
        this.changeExecListener = changeExecListener;
    }

    protected Database createDatabase(Connection c, ResourceAccessor ra) throws DatabaseException {
        Database database = super.createDatabase(c, ra);
        if (database instanceof MSSQLDatabase) {
            database.setDefaultSchemaName("dbo");
        }
        return database;
    }

    private static class UpgradeChangeExecListener
    extends AbstractChangeExecListener {
        private int applied;
        private int total;

        private UpgradeChangeExecListener() {
        }

        public void afterUpgrade() {
            if (this.applied != 0) {
                log.info("Upgrade complete. Applied {} changesets.", (Object)this.applied);
            }
        }

        public void beforeUpgrade() {
            this.applied = 0;
        }

        public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
            try {
                if (this.applied == 0) {
                    this.total = databaseChangeLog.getChangeSets().size() - database.getRanChangeSetList().size();
                    log.info("About to apply {} database upgrade tasks.", (Object)this.total);
                }
            }
            catch (DatabaseException e) {
                log.warn("An error occurred while attempting to count the remaining upgrade tasks.", (Throwable)e);
            }
            ++this.applied;
            if (this.applied % 5 == 0) {
                log.info("Applying changeset {} of {}", (Object)this.applied, (Object)this.total);
            }
        }
    }
}

