/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase.datatype;

import java.util.Locale;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.BlobType;
import liquibase.util.StringUtil;

public class CustomBlobType
extends BlobType {
    public int getPriority() {
        return 10;
    }

    public DatabaseDataType toDatabaseDataType(Database database) {
        String originalDefinition;
        if (database instanceof OracleDatabase && (originalDefinition = StringUtil.trimToEmpty((String)this.getRawDefinition())).toLowerCase(Locale.ROOT).startsWith("varbinary")) {
            if (this.useBlobForOracle()) {
                return new DatabaseDataType("BLOB");
            }
            return new DatabaseDataType("RAW", this.getParameters());
        }
        return super.toDatabaseDataType(database);
    }

    private boolean useBlobForOracle() {
        Object[] parameters = this.getParameters();
        if (parameters.length == 0) {
            return true;
        }
        Object first = parameters[0];
        if (first instanceof Number) {
            return ((Number)first).intValue() > 2000;
        }
        if (first instanceof String) {
            return Integer.parseInt((String)first) > 2000;
        }
        return true;
    }
}

