/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase.datatype;

import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.CharType;

public class CustomCharType
extends CharType {
    public int getPriority() {
        return 10;
    }

    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof MSSQLDatabase) {
            DatabaseDataType type = new DatabaseDataType("NCHAR");
            type.addAdditionalInformation(this.getAdditionalInformation());
            return type;
        }
        if (database instanceof OracleDatabase) {
            return CustomCharType.toOracleDataType("CHAR", this.getParameters());
        }
        return super.toDatabaseDataType(database);
    }

    public static DatabaseDataType toOracleDataType(String name, Object[] parameters) {
        if (parameters.length > 0) {
            parameters[0] = String.valueOf(parameters[0]) + " CHAR";
        }
        return new DatabaseDataType(name, parameters);
    }
}

