/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.merge;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.merge.InternalProjectMergeConfig;
import com.atlassian.stash.internal.merge.ProjectMergeConfigDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="projectMergeConfigDao")
public class HibernateProjectMergeConfigDao
extends AbstractHibernateDao<Long, InternalProjectMergeConfig>
implements ProjectMergeConfigDao {
    public static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.asc((String)"projectId"), HqlQueryBuilder.HqlQueryOrder.asc((String)"scmId"));

    @Autowired
    public HibernateProjectMergeConfigDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteByProjectAndScm(int projectId, @Nonnull String scmId) {
        return this.session().createQuery("delete from InternalProjectMergeConfig where projectId = :projectId and scmId = :scmId").setParameter("projectId", (Object)projectId).setParameter("scmId", (Object)scmId).executeUpdate();
    }

    public InternalProjectMergeConfig findByProjectAndScm(int projectId, @Nonnull String scmId) {
        return (InternalProjectMergeConfig)this.session().byNaturalId(InternalProjectMergeConfig.class).using("projectId", (Object)projectId).using("scmId", (Object)scmId).load();
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

