/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.merge;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.merge.InternalRepositoryMergeConfig;
import com.atlassian.stash.internal.merge.RepositoryMergeConfigDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryMergeConfigDao")
public class HibernateRepositoryMergeConfigDao
extends AbstractHibernateDao<Long, InternalRepositoryMergeConfig>
implements RepositoryMergeConfigDao {
    private static final int DELETE_ALL_MAX_SIZE = 1000;
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"repositoryId"));

    @Autowired
    public HibernateRepositoryMergeConfigDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteByRepositories(@Nonnull Set<Integer> repositoryIds) {
        if (repositoryIds.isEmpty()) {
            return 0;
        }
        if (repositoryIds.size() > 1000) {
            throw new IllegalArgumentException("Repository ids cannot exceed 1000 entries.");
        }
        String hql = "delete from InternalRepositoryMergeConfig where repositoryId in (:repositoryIds)";
        int rowsDeleted = this.session().createQuery(hql).setParameter("repositoryIds", repositoryIds).executeUpdate();
        return rowsDeleted;
    }

    public int deleteByRepository(int repositoryId) {
        return this.session().createQuery("delete from InternalRepositoryMergeConfig where repositoryId = :repositoryId").setParameter("repositoryId", (Object)repositoryId).executeUpdate();
    }

    public InternalRepositoryMergeConfig findByRepository(int repositoryId) {
        return (InternalRepositoryMergeConfig)this.session().byNaturalId(InternalRepositoryMergeConfig.class).using("repositoryId", (Object)repositoryId).load();
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

