/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.merge;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.merge.InternalScmMergeConfig;
import com.atlassian.stash.internal.merge.ScmMergeConfigDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="scmMergeConfigDao")
public class HibernateScmMergeConfigDao
extends AbstractHibernateDao<Long, InternalScmMergeConfig>
implements ScmMergeConfigDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"scmId"));

    @Autowired
    public HibernateScmMergeConfigDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteByScm(@Nonnull String scmId) {
        return this.session().createQuery("delete from InternalScmMergeConfig where scmId = :scmId").setParameter("scmId", (Object)scmId).executeUpdate();
    }

    public InternalScmMergeConfig findByScm(@Nonnull String scmId) {
        return (InternalScmMergeConfig)this.session().byNaturalId(InternalScmMergeConfig.class).using("scmId", (Object)scmId).load();
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

