/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.mesh.InternalMeshNode;
import com.atlassian.stash.internal.mesh.MeshNodeDao;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="meshNodeDao")
public class HibernateMeshNodeDao
extends AbstractHibernateDao<Long, InternalMeshNode>
implements MeshNodeDao {
    @Autowired
    public HibernateMeshNodeDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long count() {
        return (Long)this.session().createQuery("select count(n) from InternalMeshNode n", Long.class).uniqueResult();
    }

    public InternalMeshNode findByName(@Nonnull String name) {
        Objects.requireNonNull(name, "name");
        return (InternalMeshNode)this.session().createQuery("from InternalMeshNode where name = :name", InternalMeshNode.class).setParameter("name", (Object)name).setMaxResults(1).uniqueResult();
    }

    @Nonnull
    public List<InternalMeshNode> getAll() {
        return this.session().createQuery("from InternalMeshNode order by id ASC", InternalMeshNode.class).list();
    }

    public InternalMeshNode getByIdOrUrl(Long id, @Nonnull String rpcUrl) {
        Objects.requireNonNull(rpcUrl, "rpcUrl");
        if (id == null) {
            return (InternalMeshNode)this.session().createQuery("from InternalMeshNode where rpcUrl = :rpcUrl", InternalMeshNode.class).setParameter("rpcUrl", (Object)rpcUrl).uniqueResult();
        }
        return (InternalMeshNode)this.session().createQuery("from InternalMeshNode where rpcUrl = :rpcUrl or id = :id", InternalMeshNode.class).setParameter("id", (Object)id).setParameter("rpcUrl", (Object)rpcUrl).setMaxResults(1).uniqueResult();
    }
}

