/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.mesh.InternalMeshNodeKey;
import com.atlassian.stash.internal.mesh.MeshNodeKeyDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="meshNodeKeyDao")
public class HibernateMeshNodeKeyDao
extends AbstractHibernateDao<InternalMeshNodeKey.PK, InternalMeshNodeKey>
implements MeshNodeKeyDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.asc((String)"node.id"), HqlQueryBuilder.HqlQueryOrder.asc((String)"fingerprint"));

    @Autowired
    public HibernateMeshNodeKeyDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteByNode(long nodeId) {
        String hql = "delete from InternalMeshNodeKey where node.id = :nodeId";
        return this.session().createQuery(hql).setParameter("nodeId", (Object)nodeId).executeUpdate();
    }

    @Nonnull
    public List<InternalMeshNodeKey> findByNode(long nodeId) {
        String hql = "from InternalMeshNodeKey where node.id = :nodeId order by fingerprint";
        return this.session().createQuery(hql, InternalMeshNodeKey.class).setParameter("nodeId", (Object)nodeId).list();
    }

    @Nullable
    public InternalMeshNodeKey getByNodeAndFingerprint(long nodeId, @Nonnull String fingerprint) {
        Objects.requireNonNull(fingerprint, "fingerprint");
        String hql = "from InternalMeshNodeKey where node.id = :nodeId and fingerprint = :fingerprint";
        return (InternalMeshNodeKey)this.session().createQuery(hql, InternalMeshNodeKey.class).setParameter("nodeId", (Object)nodeId).setParameter("fingerprint", (Object)fingerprint).uniqueResult();
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

