/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationJobState;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationRequest;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationSearchRequest;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.mesh.InternalMeshNode_;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionMigration;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionMigration_;
import com.atlassian.stash.internal.mesh.MeshPartitionMigrationDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.SessionFactory;
import org.springframework.stereotype.Repository;

@Repository(value="meshPartitionMigrationDao")
public class HibernateMeshPartitionMigrationDao
extends AbstractHibernateDao<Long, InternalMeshPartitionMigration>
implements MeshPartitionMigrationDao {
    private static final Iterable<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.asc((String)"partition"), HqlQueryBuilder.HqlQueryOrder.asc((String)"id"));

    public HibernateMeshPartitionMigrationDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public InternalMeshPartitionMigration create(@Nonnull MeshPartitionMigrationRequest request) {
        return (InternalMeshPartitionMigration)HibernateUtils.initialize((Object)this.create(new InternalMeshPartitionMigration.Builder(request.getPartitionId(), InternalConverter.convertMeshNode((MeshNode)request.getSourceNode()), InternalConverter.convertMeshNode((MeshNode)request.getTargetNode())).uniqueToken(HibernateMeshPartitionMigrationDao.getUniqueToken(request)).build()));
    }

    @Nonnull
    public InternalMeshPartitionMigration create(InternalMeshPartitionMigration entity) {
        return (InternalMeshPartitionMigration)HibernateUtils.initialize((Object)((InternalMeshPartitionMigration)super.create((Object)new InternalMeshPartitionMigration.Builder(entity).uniqueToken(HibernateMeshPartitionMigrationDao.getUniqueToken(entity)).build())));
    }

    @Nonnull
    public Page<InternalMeshPartitionMigration> findAll(@Nonnull PageRequest pageRequest) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest));
    }

    @Nonnull
    public Page<InternalMeshPartitionMigration> findAll(@Nonnull PageRequest pageRequest, @Nonnull java.util.function.Predicate<? super InternalMeshPartitionMigration> predicate) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest, predicate));
    }

    @Nonnull
    public InternalMeshPartitionMigration getById(@Nonnull Long id) {
        return (InternalMeshPartitionMigration)HibernateUtils.initialize((Object)((InternalMeshPartitionMigration)super.getById((Serializable)id)));
    }

    @Nonnull
    public List<InternalMeshPartitionMigration> getByIds(@Nonnull Collection<Long> ids) {
        return HibernateUtils.initializeList((List)super.getByIds(ids));
    }

    @Nonnull
    public InternalMeshPartitionMigration loadById(@Nonnull Long id) {
        return (InternalMeshPartitionMigration)HibernateUtils.initialize((Object)((InternalMeshPartitionMigration)super.loadById((Serializable)id)));
    }

    @Nonnull
    public Page<InternalMeshPartitionMigration> search(@Nonnull MeshPartitionMigrationSearchRequest request, @Nonnull PageRequest pageRequest) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalMeshPartitionMigration.class);
        Root root = criteria.from(InternalMeshPartitionMigration.class);
        Join targetNode = root.join(InternalMeshPartitionMigration_.targetNode);
        Join sourceNode = root.join(InternalMeshPartitionMigration_.sourceNode);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(3);
        request.getPartition().ifPresent(value -> predicates.add(builder.equal((Expression)root.get(InternalMeshPartitionMigration_.partition), (Object)value)));
        if (!request.getTargetNodeIds().isEmpty()) {
            predicates.add(targetNode.get(InternalMeshNode_.id).in((Collection)request.getTargetNodeIds()));
        }
        if (!request.getSourceNodeIds().isEmpty()) {
            predicates.add(sourceNode.get(InternalMeshNode_.id).in((Collection)request.getSourceNodeIds()));
        }
        if (!request.getStates().isEmpty()) {
            predicates.add(root.get(InternalMeshPartitionMigration_.state).in((Collection)request.getStates()));
        }
        criteria.select((Selection)root).where(predicates.toArray(new Predicate[0]));
        return HibernateUtils.initializePage((Page)this.pageQuery(this.session().createQuery(criteria), pageRequest));
    }

    public InternalMeshPartitionMigration update(@Nonnull InternalMeshPartitionMigration entity) {
        InternalMeshPartitionMigration updated = new InternalMeshPartitionMigration.Builder(entity).updatedDate(Instant.now()).uniqueToken(HibernateMeshPartitionMigrationDao.getUniqueToken(entity)).build();
        return (InternalMeshPartitionMigration)HibernateUtils.initialize((Object)((InternalMeshPartitionMigration)super.update((Object)updated)));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    private static String getUniqueToken(InternalMeshPartitionMigration entity) {
        return HibernateMeshPartitionMigrationDao.getUniqueToken(entity.getPartition(), entity.getSourceNode().getId(), entity.getState());
    }

    private static String getUniqueToken(MeshPartitionMigrationRequest request) {
        return HibernateMeshPartitionMigrationDao.getUniqueToken(request.getPartitionId(), request.getSourceNode().getId(), MeshPartitionMigrationJobState.INITIALIZING);
    }

    private static String getUniqueToken(int partition, long sourceNodeId, MeshPartitionMigrationJobState state) {
        if (state.isTerminal()) {
            return null;
        }
        return String.format("%04x", partition) + String.format("%08x", sourceNodeId);
    }
}

