/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.mesh.InternalMeshNode;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionReplica;
import com.atlassian.stash.internal.mesh.MeshNodeDao;
import com.atlassian.stash.internal.mesh.MeshPartitionReplicaDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="meshPartitionReplicaDao")
public class HibernateMeshPartitionReplicaDao
extends AbstractHibernateDao<Long, InternalMeshPartitionReplica>
implements MeshPartitionReplicaDao {
    private static final Iterable<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.asc((String)"partition"), HqlQueryBuilder.HqlQueryOrder.asc((String)"replica"));
    private final MeshNodeDao nodeDao;

    @Autowired
    public HibernateMeshPartitionReplicaDao(SessionFactory sessionFactory, MeshNodeDao nodeDao) {
        super(sessionFactory);
        this.nodeDao = nodeDao;
    }

    public boolean existsWithRepositoriesByNode(long nodeId) {
        String hql = "from InternalMeshPartitionReplica pr where node.id = :nodeId and exists(select 1 from InternalRepository r where r.partition = pr.partition)";
        return this.session().createQuery(hql, InternalMeshPartitionReplica.class).setParameter("nodeId", (Object)nodeId).setMaxResults(1).uniqueResultOptional().isPresent();
    }

    @Nonnull
    public Page<InternalMeshPartitionReplica> findByState(@Nonnull MeshPartitionReplica.State state, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(state, "state");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return HibernateUtils.initializePage((Page)this.pageQuery(this.session().createQuery("from InternalMeshPartitionReplica where state = :state", InternalMeshPartitionReplica.class).setParameter("state", (Object)state), pageRequest));
    }

    public InternalMeshPartitionReplica findByNodeAndPartition(long nodeId, int partition) {
        String hql = "from InternalMeshPartitionReplica where node.id = :nodeId and partition = :partition";
        return (InternalMeshPartitionReplica)HibernateUtils.initialize((Object)((InternalMeshPartitionReplica)this.session().createQuery(hql, InternalMeshPartitionReplica.class).setParameter("nodeId", (Object)nodeId).setParameter("partition", (Object)partition).uniqueResult()));
    }

    @Nonnull
    public List<InternalMeshPartitionReplica> getAll() {
        return HibernateUtils.initializeList((List)this.session().createQuery("from InternalMeshPartitionReplica order by partition asc, id asc", InternalMeshPartitionReplica.class).list());
    }

    public int getNextUnassignedPartition() {
        return this.session().createQuery("SELECT max(partition) from InternalMeshPartitionReplica", Integer.class).uniqueResultOptional().map(i -> i + 1).orElse(0);
    }

    @Nonnull
    public Map<InternalMeshNode, Long> getPartitionReplicaCountByNode() {
        return (Map)this.session().createQuery("select n.id, count(p.partition) from InternalMeshNode n left outer join InternalMeshPartitionReplica p on p.node.id = n.id group by n.id", Object[].class).list().stream().collect(MoreCollectors.toImmutableMap(row -> (InternalMeshNode)this.nodeDao.getById((Object)((Long)row[0])), row -> (Long)row[1]));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

