/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.InconsistentRepositoryReplica;
import com.atlassian.bitbucket.dmz.mesh.ReplicaState;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionReplica;
import com.atlassian.stash.internal.mesh.InternalMeshRepositoryReplica;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="meshRepositoryReplicaDao")
public class HibernateMeshRepositoryReplicaDao
extends AbstractHibernateDao<InternalMeshRepositoryReplica.PK, InternalMeshRepositoryReplica>
implements MeshRepositoryReplicaDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.asc((String)"repository"), HqlQueryBuilder.HqlQueryOrder.asc((String)"replica"));

    @Autowired
    public HibernateMeshRepositoryReplicaDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteByPartitionAndHierarchy(int partition, @Nonnull String hierarchyId) {
        String hql = "delete from InternalMeshRepositoryReplica as a where exists (  select 1   from InternalMeshRepositoryReplica as b   where b.id = a.id   and b.replica.partition = :partition   and b.repository.hierarchyId = :hierarchyId)";
        Query query = this.session().createQuery(hql);
        return query.setParameter("partition", (Object)partition).setParameter("hierarchyId", (Object)hierarchyId).executeUpdate();
    }

    public int deleteByRepository(int repositoryId) {
        String hql = "delete from InternalMeshRepositoryReplica where repository.id = :repositoryId";
        return this.session().createQuery(hql).setParameter("repositoryId", (Object)repositoryId).executeUpdate();
    }

    public InternalMeshRepositoryReplica findByNodePartitionAndRepository(long nodeId, int partition, int repositoryId) {
        String hql = "from InternalMeshRepositoryReplica where replica.partition = :partition and replica.node.id = :nodeId and repository.id = :repositoryId";
        return (InternalMeshRepositoryReplica)this.session().createQuery(hql, InternalMeshRepositoryReplica.class).setParameter("nodeId", (Object)nodeId).setParameter("partition", (Object)partition).setParameter("repositoryId", (Object)repositoryId).uniqueResult();
    }

    @Nonnull
    public Map<Long, Set<Integer>> getInconsistencyMap() {
        String hql = "select r.repository.id, r.replica.node.id from InternalMeshRepositoryReplica r where r.state <> :consistent";
        HashMap<Long, Set<Integer>> result = new HashMap<Long, Set<Integer>>();
        this.session().createQuery(hql, Object[].class).setParameter("consistent", (Object)ReplicaState.CONSISTENT).list().forEach(values -> {
            Long nodeId = (Long)values[1];
            result.computeIfAbsent(nodeId, ignored -> new HashSet()).add((Integer)values[0]);
        });
        return result;
    }

    @Nonnull
    public Set<Integer> getInconsistencySetByNode(long nodeId) {
        String hql = "select r.repository.id from InternalMeshRepositoryReplica r where r.replica.node.id = :nodeId and r.state <> :consistent";
        return (Set)this.session().createQuery(hql, Integer.class).setParameter("nodeId", (Object)nodeId).setParameter("consistent", (Object)ReplicaState.CONSISTENT).stream().collect(MoreCollectors.toImmutableSet());
    }

    @Nonnull
    public List<InconsistentRepositoryReplica> getInconsistentByNode(long nodeId) {
        String hql = "select new com.atlassian.stash.internal.mesh.SimpleInconsistentRepositoryReplica(r.replica.partition, r.repository.hierarchyId, r.repository.id, r.reportedVersion) from InternalMeshRepositoryReplica r where r.replica.node.id = :nodeId and r.state <> :consistent order by r.repository.id";
        return this.session().createQuery(hql, InconsistentRepositoryReplica.class).setParameter("nodeId", (Object)nodeId).setParameter("consistent", (Object)ReplicaState.CONSISTENT).list();
    }

    @Nonnull
    public Map<Integer, Long> getInconsistentRepositoryReplicaCounts() {
        String hql = "select r.repository.id, count(r.replica.id) from InternalMeshRepositoryReplica r where r.state <> :consistent group by r.repository.id order by r.repository.id";
        return (Map)this.session().createQuery(hql, Object[].class).setParameter("consistent", (Object)ReplicaState.CONSISTENT).stream().collect(MoreCollectors.toImmutableMap(result -> (Integer)result[0], result -> (Long)result[1]));
    }

    public boolean isConsistent(int partition, long nodeId) {
        String hql = "select 1 from InternalMeshRepositoryReplica r join r.replica p where r.state <> :consistent and p.node.id = :nodeId and p.partition = :partition";
        boolean hasInconsistencies = this.session().createQuery(hql, Integer.class).setParameter("consistent", (Object)ReplicaState.CONSISTENT).setParameter("nodeId", (Object)nodeId).setParameter("partition", (Object)partition).setMaxResults(1).uniqueResultOptional().isPresent();
        return !hasInconsistencies;
    }

    public int markAllMissingForPartitionReplica(@Nonnull InternalMeshPartitionReplica partitionReplica) {
        String hql = "insert into InternalMeshRepositoryReplica(replica, repository, entityVersion, state, reportedAt, reportedVersion) select :replica, r, :entityVersion, :state, current_timestamp(), :version from InternalRepository r where r.partition = :partition";
        this.session().flush();
        return this.session().createQuery(hql).setParameter("entityVersion", (Object)0L).setParameter("partition", (Object)partitionReplica.getPartition()).setParameter("replica", (Object)partitionReplica).setParameter("state", (Object)ReplicaState.MISSING).setParameter("version", (Object)0L).executeUpdate();
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

