/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.dmz.migration.MeshMigrationJobState;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationQueueState;
import com.atlassian.bitbucket.dmz.migration.MigrationRepository;
import com.atlassian.bitbucket.dmz.migration.MigrationRepositorySearchRequest;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.migration.InternalMeshMigrationJob;
import com.atlassian.stash.internal.migration.InternalMeshMigrationQueueItem;
import com.atlassian.stash.internal.migration.MeshMigrationDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository(value="meshMigrationJobDao")
public class HibernateMeshMigrationDao
extends AbstractHibernateDao<Long, InternalMeshMigrationJob>
implements MeshMigrationDao {
    public HibernateMeshMigrationDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public InternalMeshMigrationQueueItem addToQueue(@Nonnull InternalMeshMigrationJob job, @Nonnull InternalRepository repository) {
        InternalMeshMigrationQueueItem queueItem = new InternalMeshMigrationQueueItem.Builder(job, repository).build();
        this.session().saveOrUpdate((Object)queueItem);
        return queueItem;
    }

    public InternalMeshMigrationJob findActive() {
        String hql = "from InternalMeshMigrationJob where state != :state order by id desc";
        Query query = this.session().createQuery(hql, InternalMeshMigrationJob.class).setParameter("state", (Object)MeshMigrationJobState.DONE).setMaxResults(1);
        return (InternalMeshMigrationJob)HibernateUtils.initialize((Object)((InternalMeshMigrationJob)query.uniqueResult()));
    }

    @Nonnull
    public Page<InternalMeshMigrationJob> findAllOrderedByStartTime(@Nonnull PageRequest pageRequest) {
        Query query = HqlQueryBuilder.selectFrom(InternalMeshMigrationJob.class).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.desc((String)"startTime")}).buildQuery(this.session());
        return this.pageQuery(query, pageRequest);
    }

    public InternalMeshMigrationJob findByInternalJobId(long internalJobId) {
        String hql = "from InternalMeshMigrationJob where internalJobId = :internalJobId ";
        Query query = this.session().createQuery(hql, InternalMeshMigrationJob.class).setParameter("internalJobId", (Object)internalJobId).setMaxResults(1);
        return (InternalMeshMigrationJob)HibernateUtils.initialize((Object)((InternalMeshMigrationJob)query.uniqueResult()));
    }

    public InternalMeshMigrationQueueItem getNextFromQueue(@Nonnull InternalMeshMigrationJob job) {
        String hql = "from InternalMeshMigrationQueueItem where migrationJob.id = :jobId and state = :state order by id asc ";
        Query nextItemQuery = this.session().createQuery(hql, InternalMeshMigrationQueueItem.class).setParameter("jobId", (Object)job.getId()).setParameter("state", (Object)MeshMigrationQueueState.QUEUED).setMaxResults(1);
        return (InternalMeshMigrationQueueItem)HibernateUtils.initialize((Object)((InternalMeshMigrationQueueItem)nextItemQuery.uniqueResult()));
    }

    @Nonnull
    public Map<MeshMigrationQueueState, Long> countByState(@Nonnull InternalMeshMigrationJob job) {
        String hql = "select q.state, count(*) from InternalMeshMigrationQueueItem q where q.migrationJob.id = :jobId group by q.state";
        return HibernateMeshMigrationDao.countByState((Query<Object[]>)this.session().createQuery(hql, Object[].class).setParameter("jobId", (Object)job.getId()));
    }

    @Nonnull
    public Page<MigrationRepository> searchRepositories(@Nonnull MigrationRepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        RepositorySearchQueryHelper queryHelper = new RepositorySearchQueryHelper();
        queryHelper.addSelect(request);
        Set projectKeys = request.getProjectKeys();
        if (!projectKeys.isEmpty()) {
            queryHelper.filterByProjectKeys(projectKeys);
        }
        request.getRepositoryName().ifPresent(queryHelper::filterByRepoName);
        request.getRemote().ifPresent(queryHelper::filterByRemote);
        if (request.getJobId().isPresent() && !request.getStates().isEmpty()) {
            queryHelper.filterByStates(request.getStates());
        }
        Query query = this.session().createQuery(queryHelper.buildQuery(), MigrationRepository.class);
        queryHelper.getQueryParameters().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        return this.pageQuery(query, pageRequest).transform(r -> {
            HibernateUtils.initialize((Object)r.getRepository());
            return r;
        });
    }

    public int updateQueueStateByHierarchy(@Nonnull InternalMeshMigrationJob job, @Nonnull String hierarchyId, @Nonnull Set<MeshMigrationQueueState> qualifyingStates, @Nonnull MeshMigrationQueueState targetState) {
        String hql = "update InternalMeshMigrationQueueItem set state = :targetState where migrationJob.id = :jobId and repository.id in ( select id from InternalRepository where hierarchyId = :hierarchyId) and state in (:qualifyingStates)";
        return this.session().createQuery(hql).setParameter("targetState", (Object)targetState).setParameter("jobId", (Object)job.getId()).setParameter("hierarchyId", (Object)hierarchyId).setParameterList("qualifyingStates", (Collection)(qualifyingStates.isEmpty() ? Sets.newHashSet((Object[])MeshMigrationQueueState.values()) : qualifyingStates)).executeUpdate();
    }

    public int updateQueueStateByRepository(@Nonnull InternalMeshMigrationJob job, @Nonnull InternalRepository repository, @Nonnull MeshMigrationQueueState targetState) {
        String hql = "update InternalMeshMigrationQueueItem set state = :targetState where migrationJob.id = :jobId and repository.id = :repositoryId";
        return this.session().createQuery(hql).setParameter("targetState", (Object)targetState).setParameter("jobId", (Object)job.getId()).setParameter("repositoryId", (Object)repository.getId()).executeUpdate();
    }

    private static Map<MeshMigrationQueueState, Long> countByState(Query<Object[]> query) {
        EnumMap<MeshMigrationQueueState, Long> countsByState = new EnumMap<MeshMigrationQueueState, Long>(MeshMigrationQueueState.class);
        for (Object[] column : query.list()) {
            countsByState.put((MeshMigrationQueueState)column[0], (Long)column[1]);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MeshMigrationQueueState state : MeshMigrationQueueState.values()) {
            builder.put((Object)state, (Object)countsByState.getOrDefault(state, 0L));
        }
        return builder.build();
    }

    private static class RepositorySearchQueryHelper {
        private final StringBuilder constraintsBuilder;
        private final StringBuilder joinBuilder = new StringBuilder();
        private final StringBuilder orderByBuilder;
        private final Map<String, Object> parameters;
        private final StringBuilder selectBuilder;
        private boolean hasProjectJoin;

        RepositorySearchQueryHelper() {
            this.constraintsBuilder = new StringBuilder();
            this.orderByBuilder = new StringBuilder();
            this.parameters = new HashMap<String, Object>();
            this.selectBuilder = new StringBuilder();
        }

        private void addConstraint(String constraint) {
            this.constraintsBuilder.append(this.constraintsBuilder.length() == 0 ? "where " : "and ");
            this.constraintsBuilder.append(constraint);
        }

        void addSelect(MigrationRepositorySearchRequest searchRequest) {
            if (searchRequest.getJobId().isPresent()) {
                this.selectBuilder.append("select new com.atlassian.bitbucket.dmz.migration.MigrationRepository(r, q.state) from InternalMeshMigrationQueueItem q ");
                this.joinBuilder.append("join q.repository r ");
                this.addConstraint("q.migrationJob.id = :jobId ");
                this.parameters.put("jobId", searchRequest.getJobId().get());
                this.orderByBuilder.append("order by q.id asc");
            } else {
                this.selectBuilder.append("select new com.atlassian.bitbucket.dmz.migration.MigrationRepository(r) from InternalRepository r ");
                this.joinBuilder.append("join r.project p ");
                this.hasProjectJoin = true;
                this.orderByBuilder.append("order by p.name asc, r.name asc, r.id asc");
            }
        }

        String buildQuery() {
            return this.selectBuilder.append((CharSequence)this.joinBuilder).append((CharSequence)this.constraintsBuilder).append((CharSequence)this.orderByBuilder).toString();
        }

        void filterByProjectKeys(Set<String> projectKeys) {
            if (!this.hasProjectJoin) {
                this.joinBuilder.append("join r.project p ");
                this.hasProjectJoin = true;
            }
            this.addConstraint("p.key in (:projectKeys) ");
            this.parameters.put("projectKeys", projectKeys);
        }

        void filterByRemote(Boolean remote) {
            this.addConstraint("r.partition is " + (remote != false ? "not null " : "null "));
        }

        void filterByRepoName(String repoName) {
            this.addConstraint("lower(r.name) like lower(:repoName) ");
            this.parameters.put("repoName", String.format("%%%s%%", repoName));
        }

        void filterByStates(Set<MeshMigrationQueueState> states) {
            this.addConstraint("q.state in (:states) ");
            this.parameters.put("states", states);
        }

        Map<String, Object> getQueryParameters() {
            return this.parameters;
        }
    }
}

