/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mirror.hash;

import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHash;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashType;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashes;
import com.atlassian.stash.internal.mirror.hash.InternalAbstractMirrorHash;
import com.atlassian.stash.internal.mirror.hash.InternalAbstractMirrorHash_;
import com.atlassian.stash.internal.mirror.hash.InternalMirrorContentHash;
import com.atlassian.stash.internal.mirror.hash.InternalMirrorMetadataHash;
import com.atlassian.stash.internal.mirror.hash.MirrorHashDao;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Stream;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository(value="mirrorHashDao")
public class HibernateMirrorHashDao
implements MirrorHashDao {
    private final SessionFactory sessionFactory;

    public HibernateMirrorHashDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String find(@Nonnull MirrorHashType type, int repositoryId) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(String.class);
        Root root = criteria.from(HibernateMirrorHashDao.entityForType(type));
        criteria.select((Selection)root.get(InternalAbstractMirrorHash_.hash)).where((Expression)builder.equal((Expression)root.get(InternalAbstractMirrorHash_.repositoryId), (Object)repositoryId));
        return (String)this.session().createQuery(criteria).uniqueResult();
    }

    public void set(@Nonnull MirrorHashType type, int repositoryId, @Nonnull String hash) {
        InternalMirrorContentHash.Builder builder = type == MirrorHashType.CONTENT ? new InternalMirrorContentHash.Builder(repositoryId) : new InternalMirrorMetadataHash.Builder(repositoryId);
        this.session().merge((Object)builder.hash(hash).updatedDate(new Date()).build());
    }

    @Nonnull
    public Stream<MirrorHash> stream(@Nonnull MirrorHashType type, @Nullable Date updatedSince) {
        String hql = "select new com.atlassian.stash.internal.mirror.hash.SimpleMirrorHash(h, r.project.id, p.publiclyAccessible) from " + HibernateMirrorHashDao.entityForType(type).getSimpleName() + " h join InternalRepository r on r.id = h.repositoryId left outer join InternalNormalProject p on p = r.project ";
        if (updatedSince != null) {
            hql = hql + "where h.updatedDate >= :updatedSince ";
        }
        hql = hql + " order by r.project.id asc, h.repositoryId asc";
        Query query = this.session().createQuery(hql, MirrorHash.class);
        if (updatedSince != null) {
            query.setParameter("updatedSince", (Object)updatedSince);
        }
        return HibernateMirrorHashDao.streamQuery(query);
    }

    @Nonnull
    public Stream<MirrorHashes> streamByRepositoryIds(@Nonnull Collection<Integer> repositoryIds) {
        String hql = "select new com.atlassian.stash.internal.mirror.hash.SimpleMirrorHashes(r.project.id, r.id, ch.hash, ch.updatedDate, mh.hash, mh.updatedDate, p.publiclyAccessible) from InternalRepository r left outer join InternalMirrorContentHash ch on ch.repositoryId = r.id left outer join InternalMirrorMetadataHash mh on mh.repositoryId = r.id left outer join InternalNormalProject p on p = r.project where r.id in (:repositoryIds) order by r.id asc";
        return HibernateMirrorHashDao.streamQuery(this.session().createQuery(hql, MirrorHashes.class).setParameterList("repositoryIds", repositoryIds));
    }

    @Nonnull
    public Stream<MirrorHash> streamByRepositoryIds(@Nonnull Collection<Integer> repositoryIds, @Nonnull MirrorHashType type, @Nullable Date updatedSince) {
        String hql = "select new com.atlassian.stash.internal.mirror.hash.SimpleMirrorHash(h, r.project.id, p.publiclyAccessible) from " + HibernateMirrorHashDao.entityForType(type).getSimpleName() + " h join InternalRepository r on r.id = h.repositoryId left outer join InternalNormalProject p on p = r.project where r.id in (:repositoryIds) ";
        if (updatedSince != null) {
            hql = hql + "and h.updatedDate >= :updatedSince ";
        }
        hql = hql + "order by r.id asc";
        Query query = this.session().createQuery(hql, MirrorHash.class).setParameterList("repositoryIds", repositoryIds);
        if (updatedSince != null) {
            query.setParameter("updatedSince", (Object)updatedSince);
        }
        return HibernateMirrorHashDao.streamQuery(query);
    }

    @Nonnull
    public Stream<MirrorHashes> streamRepositories() {
        String hql = "select new com.atlassian.stash.internal.mirror.hash.SimpleMirrorHashes(r.project.id, r.id, ch.hash, ch.updatedDate, mh.hash, mh.updatedDate, p.publiclyAccessible) from InternalRepository r left outer join InternalMirrorContentHash ch on ch.repositoryId = r.id left outer join InternalMirrorMetadataHash mh on mh.repositoryId = r.id left outer join InternalNormalProject p on p = r.project order by r.project.id asc, r.id asc";
        return HibernateMirrorHashDao.streamQuery(this.session().createQuery(hql, MirrorHashes.class));
    }

    private static Class<? extends InternalAbstractMirrorHash> entityForType(MirrorHashType type) {
        switch (type) {
            case CONTENT: {
                return InternalMirrorContentHash.class;
            }
            case METADATA: {
                return InternalMirrorMetadataHash.class;
            }
        }
        throw new UnsupportedOperationException(String.valueOf(type) + " hashes are not implemented");
    }

    private static <T> Stream<T> streamQuery(Query<T> query) {
        return query.setCacheMode(CacheMode.IGNORE).setFetchSize(100).setMaxResults(0x7FFFFFFE).stream();
    }

    private Session session() {
        return this.sessionFactory.getCurrentSession();
    }
}

