/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.participant;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.participant.InternalParticipable;
import com.atlassian.stash.internal.participant.InternalParticipant;
import jakarta.annotation.Nonnull;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractHibernateParticipantDao<P extends InternalParticipant<P>>
extends AbstractHibernateDao<Long, P> {
    @Autowired
    protected AbstractHibernateParticipantDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public P create(@Nonnull P participant) {
        this.session().save(participant);
        InternalParticipable entity = participant.getEntity();
        entity.addParticipant(participant);
        this.session().merge((Object)entity);
        return participant;
    }

    public void delete(@Nonnull P participant) {
        InternalParticipable entity = participant.getEntity();
        entity.removeParticipant(participant);
        this.session().update((Object)entity);
        this.session().delete(participant);
    }

    public void deleteById(Long id) {
        InternalParticipant participant = (InternalParticipant)this.getById(id);
        if (participant != null) {
            this.delete((P)participant);
        }
    }

    @Nonnull
    public P update(@Nonnull P participant) {
        return (P)((InternalParticipant)HibernateUtils.initialize((Object)((InternalParticipant)super.update(participant))));
    }
}

