/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.stash.internal.plugin.PluginSetting;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.hibernate.LockOptions;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pluginSettingDao")
public class HibernatePluginSettingDao
implements PluginSettingDao {
    private final SessionFactory sessionFactory;

    @Autowired
    public HibernatePluginSettingDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    public void attach(@Nonnull PluginSetting setting) {
        try {
            this.session().buildLockRequest(LockOptions.NONE).lock((Object)setting);
        }
        catch (NonUniqueObjectException e) {
            this.session().evict(this.access(setting.getNamespace(), setting.getKey()).getReference());
            this.session().buildLockRequest(LockOptions.NONE).lock((Object)setting);
        }
    }

    public void evict(@Nonnull String namespace, @Nonnull String key) {
        PluginSetting setting = this.getByKey(namespace, key);
        if (setting != null) {
            this.session().evict((Object)setting);
        }
    }

    @Nonnull
    public PluginSetting put(@Nonnull String namespace, @Nonnull String key, @Nonnull String val) {
        Objects.requireNonNull(namespace, "namespace");
        Objects.requireNonNull(key, "key");
        PluginSetting setting = this.getByKey(namespace, key);
        if (setting == null) {
            setting = new PluginSetting.Builder().key(key).namespace(namespace).value(val).build();
            this.session().saveOrUpdate((Object)setting);
        } else if (!Objects.equals(setting.getValue(), val)) {
            setting = new PluginSetting.Builder(setting).value(val).build();
            this.session().merge((Object)setting);
        }
        return setting;
    }

    public String get(@Nonnull String namespace, @Nonnull String key) {
        if (namespace == null || key == null) {
            return null;
        }
        PluginSetting result = this.getByKey(namespace, key);
        return result == null ? null : result.getValue();
    }

    public void remove(@Nonnull String namespace, @Nonnull String key) {
        if (namespace == null || key == null) {
            return;
        }
        PluginSetting setting = this.getByKey(namespace, key);
        if (setting != null) {
            this.session().delete((Object)setting);
        }
    }

    private NaturalIdLoadAccess access(String namespace, String key) {
        return this.session().byNaturalId(PluginSetting.class).using("namespace", (Object)namespace).using("key", (Object)key);
    }

    private PluginSetting getByKey(String namespace, String key) {
        return (PluginSetting)this.access(namespace, key).load();
    }
}

