/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.plugin.PluginState;
import com.atlassian.stash.internal.plugin.PluginStateDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import java.util.Collections;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pluginStateDao")
public class HibernatePluginStateDao
extends AbstractHibernateDao<String, PluginState>
implements PluginStateDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"name"));

    @Autowired
    public HibernatePluginStateDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void clear() {
        this.session().createQuery("delete from PluginState").executeUpdate();
    }

    public List<PluginState> findAll() {
        List result = this.session().createQuery("from PluginState").list();
        result.forEach(arg_0 -> ((Session)this.session()).evict(arg_0));
        return result;
    }

    public PluginState findByName(String name) {
        PluginState pluginState = (PluginState)this.session().createQuery("from PluginState where name = :name").setParameter("name", (Object)name).uniqueResult();
        if (pluginState != null) {
            this.session().evict((Object)pluginState);
        }
        return pluginState;
    }

    public PluginState update(PluginState entity) {
        throw new UnsupportedOperationException("PluginSettings are immutable and cannot be updated");
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

