/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.InternalProjectAlias;
import com.atlassian.stash.internal.project.ProjectAliasDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import org.hibernate.SessionFactory;
import org.springframework.stereotype.Repository;

@Repository(value="projectAliasDao")
public class HibernateProjectAliasDao
extends AbstractHibernateDao<Long, InternalProjectAlias>
implements ProjectAliasDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.desc((String)"id"));

    public HibernateProjectAliasDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public InternalProjectAlias create(@Nonnull InternalProjectAlias alias) {
        return (InternalProjectAlias)this.retryOnConstraintViolation(3, () -> {
            InternalProjectAlias current = this.getByKey(alias.getKey());
            if (current != null) {
                this.session().delete((Object)current);
                this.session().flush();
            }
            return (InternalProjectAlias)super.create((Object)alias);
        });
    }

    public void deleteByKey(@Nonnull String projectKey) {
        this.session().createQuery("delete from InternalProjectAlias where key = :pkey").setParameter("pkey", (Object)InternalProject.keyify((String)projectKey)).executeUpdate();
    }

    @Nullable
    public InternalProjectAlias getByKey(@Nonnull String projectKey) {
        return (InternalProjectAlias)HibernateUtils.initialize((Object)((InternalProjectAlias)this.session().createQuery("from InternalProjectAlias where key = :pkey", InternalProjectAlias.class).setParameter("pkey", (Object)InternalProject.keyify((String)projectKey)).uniqueResult()));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

