/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.bitbucket.project.ProjectSearchRequest;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject_;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.InternalProject_;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.project.ProjectIdKeyWrapper;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepository_;
import com.atlassian.stash.internal.user.InternalApplicationUser_;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalNormalUser_;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="projectDao")
public class HibernateProjectDao
extends AbstractHibernateDao<Integer, InternalProject>
implements ProjectDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"name").ignoreCase());

    @Autowired
    public HibernateProjectDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long countAll() {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        criteria.select((Selection)builder.count((Expression)criteria.from(InternalProject.class)));
        return (Long)this.session().createQuery(criteria).uniqueResult();
    }

    @Nonnull
    public InternalPersonalProject createPersonal(@Nonnull InternalPersonalProject project) {
        this.create(project);
        return project;
    }

    @Nonnull
    public Page<InternalProject> findAll(PageRequest pageRequest) {
        return this.findAll(pageRequest, null);
    }

    @Nonnull
    public Page<InternalProject> findAll(PageRequest pageRequest, Predicate<? super InternalProject> predicate) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalProject.class);
        Root root = criteria.from(InternalNormalProject.class);
        criteria.select((Selection)root).orderBy(new Order[]{builder.asc(builder.lower((Expression)root.get(InternalProject_.name)))});
        Query query = this.session().createQuery(criteria);
        if (predicate == null) {
            return this.pageQuery(query, pageRequest);
        }
        return this.pageQuery(query, pageRequest, predicate);
    }

    @Nonnull
    public List<String> findAllKeys(@Nonnull Predicate<? super InternalProject> predicate) {
        String hql = "select new com.atlassian.stash.internal.project.ProjectIdKeyWrapper(p.id, p.key, p.publiclyAccessible) from InternalNormalProject p order by p.key";
        return (List)this.session().createQuery(hql, ProjectIdKeyWrapper.class).list().stream().filter(predicate).map(InternalProject::getKey).collect(MoreCollectors.toImmutableList());
    }

    public InternalProject getById(Integer id) {
        return (InternalProject)HibernateUtils.initialize((Object)((InternalProject)super.getById((Serializable)id)));
    }

    @Nonnull
    public List<InternalProject> getByIds(@Nonnull Collection<Integer> ids) {
        return HibernateUtils.initializeList((List)super.getByIds(ids));
    }

    @Nullable
    public InternalProject getByKey(@Nonnull String key) {
        String hql = "from InternalProject where key = :projectKey";
        return (InternalProject)HibernateUtils.initialize((Object)((InternalProject)this.session().createQuery(hql, InternalProject.class).setParameter("projectKey", (Object)InternalProject.keyify((String)key)).setCacheable(true).setCacheRegion("query.projects").uniqueResult()));
    }

    @Nullable
    public InternalProject getByName(@Nonnull String name) {
        String hql = "from InternalProject where upper(name) = upper(:name)";
        return (InternalProject)HibernateUtils.initialize((Object)((InternalProject)this.session().createQuery(hql, InternalProject.class).setParameter("name", (Object)name).uniqueResult()));
    }

    public InternalPersonalProject getByOwner(int ownerId) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalPersonalProject.class);
        Root root = criteria.from(InternalPersonalProject.class);
        criteria.select((Selection)root).where((Expression)builder.equal((Expression)root.get(InternalPersonalProject_.owner).get(InternalApplicationUser_.id), (Object)ownerId));
        return (InternalPersonalProject)HibernateUtils.initialize((Object)((InternalPersonalProject)this.session().createQuery(criteria).uniqueResult()));
    }

    public InternalPersonalProject getByUsername(String username) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalPersonalProject.class);
        Root root = criteria.from(InternalPersonalProject.class);
        Join owner = root.join(InternalPersonalProject_.owner);
        criteria.select((Selection)root).where((Expression)builder.equal((Expression)builder.treat(owner, InternalNormalUser.class).get(InternalNormalUser_.username), (Object)IdentifierUtils.toLowerCase((String)username)));
        return (InternalPersonalProject)HibernateUtils.initialize((Object)((InternalPersonalProject)this.session().createQuery(criteria).uniqueResult()));
    }

    public boolean hasRepositories(int projectId) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(InternalRepository.class);
        criteria.select((Selection)builder.count((Expression)root)).where((Expression)builder.equal((Expression)root.get(InternalRepository_.project).get(InternalProject_.id), (Object)projectId));
        return (Long)this.session().createQuery(criteria).uniqueResult() != 0L;
    }

    @Nonnull
    public Page<InternalProject> search(@Nonnull ProjectSearchRequest searchRequest, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalProject> predicate) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalProject.class);
        Root root = criteria.from(InternalNormalProject.class);
        criteria.select((Selection)root).orderBy(new Order[]{builder.asc(builder.lower((Expression)root.get(InternalProject_.name)))});
        if (searchRequest.hasName()) {
            criteria.where((Expression)builder.like(builder.lower((Expression)root.get(InternalProject_.name)), "%" + searchRequest.getName().toLowerCase(Locale.ROOT) + "%"));
        }
        return this.pageQuery(this.session().createQuery(criteria), pageRequest, predicate);
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

