/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.util.ClassUtils;
import com.atlassian.stash.internal.pull.InternalPullRequestPhase;
import com.atlassian.stash.internal.pull.PullRequestParticipantCriteria;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import com.atlassian.stash.internal.util.LikeQueryHelper;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.query.Query;

public abstract class AbstractPullRequestQueryHelper<T> {
    private final StringBuilder constraintBuilder = new StringBuilder();
    private final StringBuilder joinBuilder = new StringBuilder();
    private final Map<String, Object> queryParameters = new HashMap<String, Object>();
    private final Class<T> resultType = (Class)ClassUtils.getTypeArguments(AbstractPullRequestQueryHelper.class, this.getClass()).get(0);
    private final Session session;
    private int participantIndex = 0;

    private AbstractPullRequestQueryHelper(@Nonnull Session session) {
        this.session = session;
    }

    public AbstractPullRequestQueryHelper(@Nonnull Session session, @Nonnull PullRequestSearchCriteria criteria) {
        this(session);
        this.setToRepositoryId(criteria.getToRepositoryId());
        this.setToRefIds(criteria.getToRefIds());
        this.setFromRepositoryId(criteria.getFromRepositoryId());
        this.setFromRefIds(criteria.getFromRefIds());
        this.setClosedSince(criteria.getClosedSince());
        this.setUpdatedSince(criteria.getUpdatedSince());
        this.setParticipants(criteria.getParticipants());
        this.setStates(criteria.getStates());
        this.setFilterText(criteria.getFilterText());
        this.setHierarchyId(criteria.getHierarchyId());
        this.setDraft(criteria.isDraft());
    }

    @Nonnull
    public Query<T> build() {
        Query query = this.session.createQuery(this.toString(), this.resultType);
        for (Map.Entry<String, Object> parameterEntry : this.queryParameters.entrySet()) {
            if (parameterEntry.getValue() instanceof Collection) {
                query.setParameterList(parameterEntry.getKey(), (Collection)parameterEntry.getValue());
                continue;
            }
            query.setParameter(parameterEntry.getKey(), parameterEntry.getValue());
        }
        return query;
    }

    public abstract String toString();

    protected void addConstraint(String constraint) {
        this.constraintBuilder.append(this.constraintBuilder.length() == 0 ? "WHERE " : "AND ");
        this.constraintBuilder.append(constraint);
    }

    String getConstraintString() {
        return this.constraintBuilder.toString();
    }

    String getJoinString() {
        return this.joinBuilder.toString();
    }

    private void addParticipant(ApplicationUser user, Set<PullRequestRole> roles, Set<PullRequestParticipantStatus> statuses) {
        if (user != null) {
            String alias = "p" + this.participantIndex++;
            this.joinBuilder.append(String.format("JOIN pr.participants %1$s WITH %1$s.user.id = :%1$sUserId ", alias));
            this.queryParameters.put(alias + "UserId", user.getId());
            if (!roles.isEmpty()) {
                ImmutableList.Builder roleClauses = new ImmutableList.Builder();
                if (roles.contains(PullRequestRole.AUTHOR)) {
                    roleClauses.add((Object)String.format("%1$s.role = :%1$sAuthorRole", alias));
                    this.queryParameters.put(alias + "AuthorRole", PullRequestRole.AUTHOR);
                }
                if (roles.contains(PullRequestRole.PARTICIPANT)) {
                    roleClauses.add((Object)String.format("%1$s.role = :%1$sParticipantRole", alias));
                    this.queryParameters.put(alias + "ParticipantRole", PullRequestRole.PARTICIPANT);
                }
                if (roles.contains(PullRequestRole.REVIEWER)) {
                    StringBuilder reviewerClause = new StringBuilder();
                    reviewerClause.append("(");
                    reviewerClause.append(String.format("%1$s.role = :%1$sReviewerRole", alias));
                    this.queryParameters.put(alias + "ReviewerRole", PullRequestRole.REVIEWER);
                    if (!statuses.isEmpty()) {
                        reviewerClause.append(String.format(" and %1$s.status in :%1$sStatus", alias));
                        this.queryParameters.put(alias + "Status", statuses);
                    }
                    reviewerClause.append(")");
                    roleClauses.add((Object)reviewerClause.toString());
                }
                String roleClause = String.format("and (%s)", String.join((CharSequence)" or ", (Iterable<? extends CharSequence>)roleClauses.build()));
                this.joinBuilder.append(roleClause);
            }
        }
    }

    private void setClosedSince(Date closedSince) {
        if (closedSince != null) {
            this.addConstraint("pr.closedDate > :closedSince ");
            this.queryParameters.put("closedSince", closedSince);
        }
    }

    private void setDraft(Boolean isDraft) {
        if (isDraft != null) {
            InternalPullRequestPhase phase = isDraft != false ? InternalPullRequestPhase.DRAFT : InternalPullRequestPhase.PUBLISHED;
            this.addConstraint("pr.phase = :phase ");
            this.queryParameters.put("phase", phase);
        }
    }

    private void setFilterText(String filterText) {
        if (!StringUtils.isBlank((CharSequence)filterText)) {
            this.addConstraint("(lower(pr.title) like :filterText escape '!' OR lower(pr.description) like :filterText escape '!') ");
            filterText = LikeQueryHelper.matchesAnywhere(this.session, filterText).toLowerCase().replaceAll("\\s+", "%");
            this.queryParameters.put("filterText", filterText);
        }
    }

    private void setFromRefIds(Collection<String> fromRefIds) {
        if (fromRefIds != null && !fromRefIds.isEmpty()) {
            this.addConstraint("pr.fromRef.id in (:fromRefIds) ");
            this.queryParameters.put("fromRefIds", fromRefIds);
        }
    }

    private void setFromRepositoryId(Integer fromRepositoryId) {
        if (fromRepositoryId != null) {
            this.addConstraint("pr.fromRef.repository.id = :fromRepositoryId ");
            this.queryParameters.put("fromRepositoryId", fromRepositoryId);
        }
    }

    private void setHierarchyId(String hierarchyId) {
        if (StringUtils.isNotEmpty((CharSequence)hierarchyId)) {
            this.addConstraint("pr.toRef.repository.hierarchyId = :hierarchyId ");
            this.queryParameters.put("hierarchyId", hierarchyId);
        }
    }

    private void setParticipants(Iterable<PullRequestParticipantCriteria> participants) {
        for (PullRequestParticipantCriteria participant : participants) {
            this.addParticipant(participant.getUser(), participant.getRoles(), participant.getStatuses());
        }
    }

    private void setStates(Collection<PullRequestState> pullRequestStates) {
        if (pullRequestStates != null && !pullRequestStates.isEmpty()) {
            this.addConstraint("pr.state in (:states) ");
            this.queryParameters.put("states", pullRequestStates);
        }
    }

    private void setToRefIds(Collection<String> toRefIds) {
        if (toRefIds != null && !toRefIds.isEmpty()) {
            this.addConstraint("pr.toRef.id in (:toRefIds) ");
            this.queryParameters.put("toRefIds", toRefIds);
        }
    }

    private void setToRepositoryId(Integer toRepositoryId) {
        if (toRepositoryId != null) {
            this.addConstraint("pr.toRef.repository.id = :toRepositoryId ");
            this.queryParameters.put("toRepositoryId", toRepositoryId);
        }
    }

    private void setUpdatedSince(Date updatedSince) {
        if (updatedSince != null) {
            this.addConstraint("pr.updatedDate > :updatedSince ");
            this.queryParameters.put("updatedSince", updatedSince);
        }
    }
}

