/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.dmz.pull.PullRequestActivitySummary;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivityPage;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.pull.SimplePullRequestActivityPage;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.activity.AbstractHibernateActivityDao;
import com.atlassian.stash.internal.activity.IntegrityCheckMergeActivity;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestMergeActivity;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestActivitySearchCriteria;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.CacheMode;
import org.hibernate.Hibernate;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="pullRequestActivityDao")
@DefaultApplicationMode
public class HibernatePullRequestActivityDao
extends AbstractHibernateActivityDao<InternalPullRequestActivity>
implements PullRequestActivityDao {
    private final int maxScanPages;
    private final int scanPageSize;

    @Autowired
    public HibernatePullRequestActivityDao(SessionFactory sessionFactory, @Value(value="${page.scan.pullrequest.activity.size}") int scanPageSize, @Value(value="${page.scan.pullrequest.activity.count}") int maxScanPageCount) {
        super(sessionFactory);
        this.maxScanPages = maxScanPageCount;
        this.scanPageSize = scanPageSize;
    }

    public long countByUser(long pullRequestId, int userId, @Nonnull Set<PullRequestAction> includedActions, @Nonnull Set<PullRequestAction> excludedActions) {
        Set<PullRequestAction> actions = this.getIncludedActions(includedActions, excludedActions);
        if (actions.isEmpty()) {
            return 0L;
        }
        Query query = this.session().createQuery("select count(activity) from InternalPullRequestActivity activity where activity.pullRequest.id = :pullRequestId and activity.action in (:actions) and activity.user.id = :userId").setParameter("pullRequestId", (Object)pullRequestId, (Type)StandardBasicTypes.LONG).setParameterList("actions", actions).setParameter("userId", (Object)userId, (Type)StandardBasicTypes.INTEGER);
        return (Long)query.uniqueResult();
    }

    @Nonnull
    public Map<Long, Long> countCommentsByPullRequest(@Nonnull Set<Long> pullRequestIds) {
        if (pullRequestIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List results = this.session().createQuery("select a.pullRequest.id, count(*) from InternalPullRequestCommentActivity a where a.pullRequest.id in (:pullRequestIds) and a.commentAction in (:actions) group by a.pullRequest.id").setParameterList("pullRequestIds", pullRequestIds).setParameterList("actions", EnumSet.of(CommentAction.ADDED, CommentAction.REPLIED)).list();
        HashMap<Long, Long> counts = new HashMap<Long, Long>(results.size(), 1.0f);
        for (Object result : results) {
            Object[] columns = (Object[])result;
            counts.put((Long)columns[0], (Long)columns[1]);
        }
        return counts;
    }

    public int deleteByComment(long commentId) {
        int count = this.session().createQuery("delete from InternalPullRequestCommentActivity where comment.id = :commentId").setParameter("commentId", (Object)commentId, (Type)StandardBasicTypes.LONG).executeUpdate();
        return count + this.session().createQuery("delete from InternalCommitDiscussionCommentActivity where comment.id = :commentId").setParameter("commentId", (Object)commentId, (Type)StandardBasicTypes.LONG).executeUpdate();
    }

    public int deleteByPullRequest(long pullRequestId) {
        return this.maybeBulkDelete("from InternalPullRequestActivity where pullRequest.id = :pullRequestId", (Map)ImmutableMap.of((Object)"pullRequestId", (Object)pullRequestId));
    }

    public int deleteByRepository(int repositoryId) {
        return this.maybeBulkDelete("from InternalPullRequestActivity where pullRequest.id in (select id from InternalPullRequest where toRef.repository.id = :repositoryId)", (Map)ImmutableMap.of((Object)"repositoryId", (Object)repositoryId));
    }

    public int deleteEmptyRescopes() {
        return this.maybeBulkDelete("from InternalPullRequestRescopeActivity where totalAdded != null and totalRemoved != null and totalAdded = 0 and totalRemoved = 0");
    }

    @Nonnull
    public Page<InternalPullRequestActivity> exportActivities(long globalId, @Nonnull PageRequest pageRequest) {
        String hql = "select a from InternalPullRequestActivity a left outer join a.comment c left outer join c.thread t left outer join a.commits inner join a.user where a.pullRequest.id = :pullRequestId order by  coalesce(t.id, :bigBigInt) asc, case   when a.type = :commentType and a.commentAction = :addedAction then 0   else 1  end asc,  a.createdDate asc,  a.id asc";
        Query query = this.session().createQuery(hql, InternalPullRequestActivity.class).setParameter("addedAction", (Object)CommentAction.ADDED).setParameter("commentType", (Object)2, (Type)StandardBasicTypes.INTEGER).setParameter("bigBigInt", (Object)Long.MAX_VALUE, (Type)StandardBasicTypes.LONG).setParameter("pullRequestId", (Object)globalId, (Type)StandardBasicTypes.LONG);
        Page activities = this.pageQuery(query, pageRequest);
        MoreStreams.streamIterable((Iterable)activities.getValues()).filter(InternalPullRequestCommentActivity.class::isInstance).map(InternalPullRequestCommentActivity.class::cast).filter(commentActivity -> commentActivity.getCommentAction() == CommentAction.ADDED).forEach(commentActivity -> HibernateUtils.initialize((Object)commentActivity.getComment()));
        return activities;
    }

    public InternalPullRequestCommentActivity findByComment(long pullRequestId, long commentId) {
        String hql = "select a from InternalPullRequestCommentActivity a where a.pullRequest.id = :pullRequestId and a.comment.id = :commentId and a.commentAction = :addedAction";
        Query query = this.session().createQuery(hql, InternalPullRequestCommentActivity.class).setParameter("pullRequestId", (Object)pullRequestId).setParameter("commentId", (Object)commentId).setParameter("addedAction", (Object)CommentAction.ADDED);
        return (InternalPullRequestCommentActivity)HibernateUtils.initialize((Object)((InternalPullRequestCommentActivity)query.uniqueResult()));
    }

    @Nonnull
    public Page<InternalPullRequestActivity> findByPullRequest(long pullRequestId, @Nonnull PageRequest pageRequest) {
        return HibernateUtils.initializePage(this.getPageOfActivities(pullRequestId, pageRequest));
    }

    @Nonnull
    public List<Long> findCalculableRescopes() {
        String hql = "        select a.id from InternalPullRequestRescopeActivity a inner join a.pullRequest pr\n        where a.totalAdded is null\n        and a.pullRequest.state = :openState\n";
        return this.session().createQuery(hql).setParameter("openState", (Object)PullRequestState.OPEN).list();
    }

    @Nonnull
    public Page<IntegrityCheckMergeActivity> findLatestMergeActivityInHierarchySince(@Nonnull Date createdSince, @Nonnull String hierarchyId, @Nonnull PageRequest pageRequest) {
        String hql = "select max(ipa) from InternalPullRequestMergeActivity ipa where createdDate > :createdSince and pullRequest.toRef.repository.hierarchyId = :hierarchyId group by ipa.pullRequest";
        Query query = this.session().createQuery(hql, InternalPullRequestMergeActivity.class).setParameter("createdSince", (Object)createdSince).setParameter("hierarchyId", (Object)hierarchyId);
        return this.pageQuery(query, pageRequest).transform(this::initializationForIntegrityChecking);
    }

    @Nonnull
    public Page<IntegrityCheckMergeActivity> findLatestMergeActivitySince(@Nonnull Date createdSince, @Nonnull PageRequest pageRequest) {
        String hql = "select max(ipa) from InternalPullRequestMergeActivity ipa where createdDate > :createdSince group by ipa.pullRequest";
        Query query = this.session().createQuery(hql, InternalPullRequestMergeActivity.class).setParameter("createdSince", (Object)createdSince);
        return this.pageQuery(query, pageRequest).transform(this::initializationForIntegrityChecking);
    }

    @Nonnull
    public PullRequestActivityPage<InternalPullRequestActivity> findPageStartingAt(long pullRequestId, long activityId, @Nonnull PageRequest pageRequest) {
        if (pageRequest.getLimit() > this.scanPageSize) {
            throw new IllegalArgumentException("Page limit is too large. It must be less than " + this.scanPageSize);
        }
        InternalPullRequestActivity targetActivity = this.getById(activityId);
        if (targetActivity != null) {
            InternalPullRequest pullRequest = targetActivity.getPullRequest();
            if (pullRequest.getGlobalId() != pullRequestId) {
                throw new IllegalArgumentException("The pull request supplied does not match the pull request of the activity");
            }
            Iterator activities = new PagedIterable(request -> {
                if (request.getStart() > this.maxScanPages * this.scanPageSize) {
                    return PageUtils.createEmptyPage((PageRequest)request);
                }
                return this.getPageOfActivities(pullRequest.getGlobalId(), request);
            }, PageUtils.newRequest((int)0, (int)this.scanPageSize)).iterator();
            ArrayDeque<InternalPullRequestActivity> activityWindow = new ArrayDeque<InternalPullRequestActivity>(pageRequest.getLimit());
            int activityCount = 0;
            Long noId = -1L;
            while (activities.hasNext()) {
                InternalPullRequestActivity activity = (InternalPullRequestActivity)activities.next();
                if (activity.getId() == activityId) {
                    ArrayList page = Lists.newArrayListWithCapacity((int)pageRequest.getLimit());
                    int start = activityCount;
                    if (activityWindow.size() < pageRequest.getLimit()) {
                        start = 0;
                        page.addAll(activityWindow);
                    }
                    page.add(activity);
                    Iterators.addAll((Collection)page, (Iterator)Iterators.limit((Iterator)activities, (int)(pageRequest.getLimit() - page.size())));
                    boolean isLastPage = !activities.hasNext();
                    Long previousStartId = start == 0 ? noId.longValue() : ((InternalPullRequestActivity)activityWindow.peekFirst()).getId();
                    return new SimplePullRequestActivityPage(PageUtils.createPage((Iterable)HibernateUtils.initializeList((List)page), (boolean)isLastPage, (PageRequest)PageUtils.newRequest((int)start, (int)pageRequest.getLimit())), previousStartId.longValue());
                }
                if (activityWindow.size() == pageRequest.getLimit()) {
                    activityWindow.pollFirst();
                }
                activityWindow.add(activity);
                ++activityCount;
            }
        }
        return new SimplePullRequestActivityPage(PageUtils.createEmptyPage((PageRequest)pageRequest), -1L);
    }

    @Nonnull
    public Set<InternalApplicationUser> findUsersWithActivities(long pullRequestId, @Nonnull Set<PullRequestAction> includedActions, @Nonnull Set<PullRequestAction> excludedActions) {
        Set<PullRequestAction> actions = this.getIncludedActions(includedActions, excludedActions);
        if (actions.isEmpty()) {
            return Collections.emptySet();
        }
        Query query = this.session().createQuery("select distinct(activity.user) from InternalPullRequestActivity activity where activity.pullRequest.id = :pullRequestId and activity.action in (:actions)").setParameter("pullRequestId", (Object)pullRequestId, (Type)StandardBasicTypes.LONG).setParameterList("actions", actions);
        return Sets.newHashSet((Iterable)query.list());
    }

    public InternalPullRequestActivity getById(Long id) {
        return (InternalPullRequestActivity)HibernateUtils.initialize((Object)((InternalPullRequestActivity)super.getById((Serializable)id)));
    }

    @Nonnull
    public List<InternalPullRequestActivity> getByIds(@Nonnull Collection<Long> ids) {
        return HibernateUtils.initializeList((List)super.getByIds(ids));
    }

    @Nonnull
    public Page<InternalPullRequestActivity> search(@Nonnull PullRequestActivitySearchCriteria searchCriteria, @Nonnull PageRequest pageRequest) {
        ArrayList<HqlQueryBuilder.HqlWhereConditionalQueryComponent> typeClauses = new ArrayList<HqlQueryBuilder.HqlWhereConditionalQueryComponent>();
        for (Integer type : searchCriteria.getTypes()) {
            HqlQueryBuilder.HqlWhereConditionalQueryComponent searchParameters = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"type", (Object)type)});
            if (type == 2) {
                if (CollectionUtils.isNotEmpty((Collection)searchCriteria.getCommentActions())) {
                    searchParameters.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"commentAction", (Collection)searchCriteria.getCommentActions())});
                }
                if (CollectionUtils.isNotEmpty((Collection)searchCriteria.getCommentIds())) {
                    searchParameters.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"comment.id", (Collection)searchCriteria.getCommentIds())});
                }
            }
            typeClauses.add(searchParameters);
        }
        HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"pullRequest.id", (Object)searchCriteria.getPullRequestId())});
        if (!typeClauses.isEmpty()) {
            conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.or(typeClauses)});
        }
        Query query = HqlQueryBuilder.selectFrom(InternalPullRequestActivity.class).where((HqlQueryBuilder.HqlWhereQueryComponent)conditionals).orderBy(this.getImplicitOrder()).buildQuery(this.session());
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Nonnull
    public Stream<PullRequestActivitySummary> streamActivitySummaryForOpenPullRequests() {
        String hql = "select new com.atlassian.stash.internal.pull.SimplePullRequestActivitySummary(pr.scopedId, pr.toRef.repository.id, pr.version, max(pa.createdDate)) from InternalPullRequestActivity pa join pa.pullRequest pr where pr.state = :open group by pr.toRef.repository.id, pr.scopedId, pr.version order by pr.toRef.repository.id, pr.scopedId";
        return this.session().createQuery(hql, PullRequestActivitySummary.class).setParameter("open", (Object)PullRequestState.OPEN).setCacheMode(CacheMode.IGNORE).setFetchSize(100).setMaxResults(0x7FFFFFFE).stream();
    }

    private Set<PullRequestAction> getIncludedActions(Set<PullRequestAction> includedActions, Set<PullRequestAction> excludedActions) {
        return includedActions.isEmpty() ? Sets.complementOf(excludedActions, PullRequestAction.class) : Sets.difference(includedActions, excludedActions);
    }

    private Page<InternalPullRequestActivity> getPageOfActivities(long pullRequestId, PageRequest pageRequest) {
        String hql = "select a from InternalPullRequestActivity a left outer join InternalComment c on c.id = a.comment.id left outer join InternalCommentThread t on t.id = c.thread.id where a.pullRequest.id = :pullRequestId and not (  (a.type = :genericType and (a.action = :rescopedAction or a.action = :updatedAction))   or (a.type = :commentType and a.commentAction <> :addedAction)   or (a.type = :rescopeType     and a.totalAdded is not null    and a.totalRemoved is not null    and a.totalAdded = 0    and a.totalRemoved = 0)) order by coalesce(t.updatedDate, a.createdDate) desc, a.id desc";
        Query query = this.session().createQuery(hql, InternalPullRequestActivity.class).setParameter("addedAction", (Object)CommentAction.ADDED).setParameter("commentType", (Object)2, (Type)StandardBasicTypes.INTEGER).setParameter("genericType", (Object)1, (Type)StandardBasicTypes.INTEGER).setParameter("pullRequestId", (Object)pullRequestId, (Type)StandardBasicTypes.LONG).setParameter("rescopeType", (Object)4, (Type)StandardBasicTypes.INTEGER).setParameter("rescopedAction", (Object)PullRequestAction.RESCOPED).setParameter("updatedAction", (Object)PullRequestAction.UPDATED);
        return this.pageQuery(query, pageRequest);
    }

    private IntegrityCheckMergeActivity initializationForIntegrityChecking(InternalPullRequestMergeActivity activity) {
        Hibernate.initialize((Object)activity.getPullRequest().getScopeRepository().getProject());
        HibernateUtils.initialize((Object)activity.getPullRequest().getToRef());
        return new IntegrityCheckMergeActivity(activity);
    }
}

