/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestCommit;
import com.atlassian.stash.internal.pull.PullRequestCommitDao;
import com.atlassian.stash.internal.pull.PullRequestCommitSearchCriteria;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pullRequestCommitDao")
public class HibernatePullRequestCommitDao
extends AbstractHibernateDao<InternalPullRequestCommit.PK, InternalPullRequestCommit>
implements PullRequestCommitDao {
    private static final Iterable<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.asc((String)"commitId"), HqlQueryBuilder.HqlQueryOrder.desc((String)"pullRequest.id"));

    @Autowired
    public HibernatePullRequestCommitDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long count(@Nonnull PullRequestCommitSearchCriteria criteria) {
        return (Long)this.findPullRequestsQuery(criteria, Long.class).uniqueResult();
    }

    public long countByPullRequest(long pullRequestId) {
        return (Long)this.session().createQuery("SELECT COUNT(*) FROM InternalPullRequestCommit WHERE pullRequest.id = :prId", Long.class).setParameter("prId", (Object)pullRequestId, (Type)StandardBasicTypes.LONG).uniqueResult();
    }

    public int deleteByPullRequest(long pullRequestId) {
        return this.session().createQuery("DELETE InternalPullRequestCommit WHERE pullRequest.id = :prId").setParameter("prId", (Object)pullRequestId, (Type)StandardBasicTypes.LONG).executeUpdate();
    }

    public int deleteByPullRequests(@Nonnull Collection<Long> pullRequestIds) {
        int result = 0;
        for (List partition : Iterables.partition(pullRequestIds, (int)100)) {
            result += this.session().createQuery("DELETE InternalPullRequestCommit WHERE pullRequest.id IN (:prIds)").setParameterList("prIds", (Collection)partition, (Type)StandardBasicTypes.LONG).executeUpdate();
        }
        return result;
    }

    @Nonnull
    public Page<InternalPullRequest> searchPullRequests(@Nonnull PullRequestCommitSearchCriteria criteria, @Nonnull PageRequest pageRequest) {
        return HibernateUtils.initializePage((Page)this.pageQuery(this.findPullRequestsQuery(criteria, InternalPullRequest.class), pageRequest));
    }

    @Nonnull
    public Page<InternalPullRequest> searchPullRequests(@Nonnull PullRequestCommitSearchCriteria criteria, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalPullRequest> predicate) {
        return HibernateUtils.initializePage((Page)this.pageQuery(this.findPullRequestsQuery(criteria, InternalPullRequest.class), pageRequest, predicate));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    private <T> Query<T> findPullRequestsQuery(PullRequestCommitSearchCriteria criteria, Class<T> queryType) {
        boolean isCountQuery = Number.class.isAssignableFrom(queryType);
        boolean hasStates = criteria.hasStates();
        boolean hasToRepository = criteria.hasToRepositoryId();
        StringBuilder queryString = new StringBuilder("SELECT ");
        if (isCountQuery) {
            queryString.append("count(prc)");
        } else if (InternalPullRequest.class.equals(queryType)) {
            queryString.append("prc.pullRequest");
        } else {
            throw new IllegalArgumentException("Unknown query type: " + String.valueOf(queryType));
        }
        queryString.append(" FROM InternalPullRequestCommit prc WHERE prc.commitId = :commitId");
        if (hasToRepository) {
            queryString.append(" AND prc.pullRequest.toRef.repository.id = :toRepositoryId");
        }
        if (hasStates) {
            queryString.append(" AND prc.pullRequest.state in (:states)");
        }
        if (!isCountQuery) {
            queryString.append(" ORDER BY prc.pullRequest.updatedDate DESC");
        }
        Query query = this.session().createQuery(queryString.toString(), queryType).setParameter("commitId", (Object)criteria.getCommitId(), (Type)StandardBasicTypes.STRING);
        if (hasStates) {
            query = query.setParameterList("states", (Collection)criteria.getStates());
        }
        if (hasToRepository) {
            query = query.setParameter("toRepositoryId", (Object)criteria.getToRepositoryId(), (Type)StandardBasicTypes.INTEGER);
        }
        return query;
    }
}

