/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummaryField;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummaryRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.CommentThreadDao;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.pull.InternalPullRequestRef_;
import com.atlassian.stash.internal.pull.InternalPullRequestSummary;
import com.atlassian.stash.internal.pull.InternalPullRequest_;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestCountQueryHelper;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import com.atlassian.stash.internal.pull.PullRequestSearchQueryHelper;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository_;
import com.atlassian.stash.internal.repository.RepositoryScope;
import com.atlassian.stash.internal.repository.RepositoryScopedIdGenerator;
import com.atlassian.stash.internal.util.LikeQueryHelper;
import com.atlassian.stash.internal.util.NumberBuffer;
import com.atlassian.stash.internal.util.ScrollableResultsHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import jakarta.annotation.Nonnull;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.LongStream;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pullRequestDao")
public class HibernatePullRequestDao
extends AbstractHibernateDao<Long, InternalPullRequest>
implements PullRequestDao {
    public static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.desc((String)"updatedDate"));
    private final PullRequestActivityDao activityDao;
    private final CommentThreadDao commentThreadDao;
    private final RepositoryScopedIdGenerator idGenerator;

    @Autowired
    public HibernatePullRequestDao(SessionFactory sessionFactory, PullRequestActivityDao activityDao, CommentThreadDao commentThreadDao, RepositoryScopedIdGenerator idGenerator) {
        super(sessionFactory);
        this.activityDao = activityDao;
        this.commentThreadDao = commentThreadDao;
        this.idGenerator = idGenerator;
    }

    public Map<PullRequestState, Long> countAllByState() {
        String hql = "select state, count(*) from InternalPullRequest group by state";
        return this.countByState((Query<Object[]>)this.session().createQuery(hql, Object[].class));
    }

    public Map<PullRequestState, Long> countByState(int repositoryId) {
        String hql = "select state, count(*) from InternalPullRequest where toRef.repository.id = :repositoryId group by state";
        Query query = this.session().createQuery(hql, Object[].class).setParameter("repositoryId", (Object)repositoryId, (Type)StandardBasicTypes.INTEGER);
        return this.countByState((Query<Object[]>)query);
    }

    public long countMatching(@Nonnull PullRequestSearchCriteria searchCriteria) {
        return (Long)new PullRequestCountQueryHelper(this.session(), searchCriteria).build().setCacheable(true).setCacheRegion("query.pullRequestCountByUser").uniqueResult();
    }

    @Nonnull
    public InternalPullRequest create(InternalPullRequest entity) {
        if (entity.getScopedId() == 0L) {
            long scopedId = this.idGenerator.nextId(entity.getScopeRepository().getId(), entity.getScope());
            entity.setScopedId(scopedId);
        }
        return (InternalPullRequest)super.create((Object)entity);
    }

    public int declineByFromRepository(int repositoryId) {
        String hql = "update InternalPullRequest set state = :declined where fromRef.repository.id = :repoId and state = :open";
        return this.session().createQuery(hql).setParameter("repoId", (Object)repositoryId, (Type)StandardBasicTypes.INTEGER).setParameter("declined", (Object)PullRequestState.DECLINED).setParameter("open", (Object)PullRequestState.OPEN).executeUpdate();
    }

    public void delete(InternalPullRequest entity) {
        long globalId = entity.getGlobalId();
        Session session = this.session();
        session.createQuery("delete from InternalWatcherMapping where watchableId = :prId and watchableType = :typeId").setParameter("prId", (Object)globalId, (Type)StandardBasicTypes.LONG).setParameter("typeId", (Object)1, (Type)StandardBasicTypes.INTEGER).executeUpdate();
        List threadIds = session.createQuery("select distinct comment.thread.id from InternalPullRequestCommentActivity where pullRequest.id = :pullRequestId", Long.class).setParameter("pullRequestId", (Object)globalId, (Type)StandardBasicTypes.LONG).list();
        this.activityDao.deleteByPullRequest(globalId);
        this.commentThreadDao.deleteByIds(threadIds);
        session.flush();
        super.delete((Object)entity);
    }

    public int deleteByToRepository(int repositoryId) {
        Session session = this.session();
        session.createQuery("delete from InternalWatcherMapping where watchableId in (select id from InternalPullRequest where toRef.repository.id = :repoId) and watchableType = :typeId").setParameter("repoId", (Object)repositoryId, (Type)StandardBasicTypes.INTEGER).setParameter("typeId", (Object)1, (Type)StandardBasicTypes.INTEGER).executeUpdate();
        String hql = "select distinct comment.thread.id from InternalPullRequestCommentActivity where pullRequest.toRef.repository.id = :repositoryId";
        List threadIds = session.createQuery(hql, Long.class).setParameter("repositoryId", (Object)repositoryId, (Type)StandardBasicTypes.INTEGER).list();
        this.activityDao.deleteByRepository(repositoryId);
        this.commentThreadDao.deleteByIds(threadIds);
        int updated = session.createQuery("delete from InternalPullRequest where toRef.repository.id = :repoId").setParameter("repoId", (Object)repositoryId, (Type)StandardBasicTypes.INTEGER).executeUpdate();
        session.flush();
        return updated;
    }

    public InternalPullRequest findByComment(long commentId) {
        String hql = "select a.pullRequest from InternalPullRequestCommentActivity a where a.comment.id = :commentId and a.commentAction in (:actions)";
        Query query = this.session().createQuery(hql, InternalPullRequest.class).setParameter("commentId", (Object)commentId).setParameterList("actions", EnumSet.of(CommentAction.ADDED, CommentAction.REPLIED));
        return (InternalPullRequest)HibernateUtils.initialize((Object)((InternalPullRequest)query.uniqueResult()));
    }

    @Nonnull
    public Page<InternalPullRequest> findByRefs(@Nonnull InternalPullRequestRef from, @Nonnull InternalPullRequestRef to, @Nonnull PageRequest pageRequest) {
        String hql = "from InternalPullRequest where toRef.repository.id = :toRepositoryId and toRef.id = :toBranchFqn and fromRef.repository.id = :fromRepositoryId and fromRef.id = :fromBranchFqn and state = :state order by id asc";
        Query query = this.session().createQuery(hql, InternalPullRequest.class).setParameter("toRepositoryId", (Object)to.getRepository().getId(), (Type)StandardBasicTypes.INTEGER).setParameter("toBranchFqn", (Object)to.getId()).setParameter("fromRepositoryId", (Object)from.getRepository().getId(), (Type)StandardBasicTypes.INTEGER).setParameter("fromBranchFqn", (Object)from.getId()).setParameter("state", (Object)PullRequestState.OPEN);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Nonnull
    public Page<InternalPullRequest> findByRepositoryHierarchyId(@Nonnull String hierarchyId, @Nonnull PageRequest pageRequest) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalPullRequest.class);
        Root root = criteria.from(InternalPullRequest.class);
        criteria.select((Selection)root).where((Expression)builder.equal((Expression)root.get(InternalPullRequest_.toRef).get(InternalPullRequestRef_.repository).get(InternalRepository_.hierarchyId), (Object)hierarchyId)).orderBy(new Order[]{builder.asc((Expression)root.get(InternalPullRequest_.createdDate)), builder.asc((Expression)root.get(InternalPullRequest_.id))});
        return HibernateUtils.initializePage((Page)this.pageQuery(this.session().createQuery(criteria), pageRequest));
    }

    public InternalPullRequest findByRepositoryScopedId(int repositoryId, long pullRequestId) {
        String hql = "from InternalPullRequest where toRef.repository.id = :repositoryId and scopedId = :pullRequestId";
        Query query = this.session().createQuery(hql, InternalPullRequest.class).setParameter("repositoryId", (Object)repositoryId).setParameter("pullRequestId", (Object)pullRequestId);
        return (InternalPullRequest)HibernateUtils.initialize((Object)((InternalPullRequest)query.uniqueResult()));
    }

    public Collection<InternalPullRequest> findByRepositoryScopedIds(int repositoryId, @Nonnull Set<Long> pullRequestIds) {
        String hql = "from InternalPullRequest where toRef.repository.id = :repositoryId and scopedId in :pullRequestIds";
        Query query = this.session().createQuery(hql, InternalPullRequest.class).setParameter("repositoryId", (Object)repositoryId).setParameter("pullRequestIds", pullRequestIds);
        return (Collection)HibernateUtils.initialize((Object)query.getResultList());
    }

    public InternalPullRequest findLatestByRepositoryHierarchyId(@Nonnull String hierarchyId) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalPullRequest.class);
        Root root = criteria.from(InternalPullRequest.class);
        criteria.select((Selection)root).where((Expression)builder.equal((Expression)root.get(InternalPullRequest_.toRef).get(InternalPullRequestRef_.repository).get(InternalRepository_.hierarchyId), (Object)hierarchyId)).orderBy(new Order[]{builder.desc((Expression)root.get(InternalPullRequest_.updatedDate)), builder.desc((Expression)root.get(InternalPullRequest_.id))});
        return (InternalPullRequest)HibernateUtils.initialize((Object)((InternalPullRequest)this.session().createQuery(criteria).setMaxResults(1).uniqueResult()));
    }

    @Nonnull
    public Page<InternalPullRequest> findUnmergedByFromRepository(int repositoryId, @Nonnull PageRequest pageRequest) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalPullRequest.class);
        Root root = criteria.from(InternalPullRequest.class);
        criteria.select((Selection)root).where(new Predicate[]{builder.equal((Expression)root.get(InternalPullRequest_.fromRef).get(InternalPullRequestRef_.repository).get(InternalRepository_.id), (Object)repositoryId), builder.notEqual((Expression)root.get(InternalPullRequest_.state), (Object)PullRequestState.MERGED)}).orderBy(new Order[]{builder.asc((Expression)root.get(InternalPullRequest_.id))});
        return this.pageQuery(this.session().createQuery(criteria), pageRequest);
    }

    public InternalPullRequest getById(Long id) {
        return (InternalPullRequest)HibernateUtils.initialize((Object)((InternalPullRequest)super.getById((Serializable)id)));
    }

    @Nonnull
    public Map<Integer, Long> getHighestScopedIdsByRepository() {
        String hql = "select toRef.repository.id, max(scopedId) from InternalPullRequest group by toRef.repository.id";
        Query query = this.session().createQuery(hql, Object[].class);
        HashMap<Integer, Long> scopedIdsByRepository = new HashMap<Integer, Long>();
        this.scrollQuery(query, results -> scopedIdsByRepository.put(results.getInteger(0), results.getLong(1)));
        return scopedIdsByRepository;
    }

    public int overwriteFromRepository(int repositoryId) {
        String hql = "update InternalPullRequest set fromRef.repository.id = toRef.repository.id where fromRef.repository.id = :repoId";
        int updated = this.session().createQuery(hql).setParameter("repoId", (Object)repositoryId, (Type)StandardBasicTypes.INTEGER).executeUpdate();
        this.session().flush();
        return updated;
    }

    public void refresh(InternalPullRequest entity) {
        super.refresh((Object)entity);
        HibernateUtils.initialize((Object)entity);
    }

    public void resyncNextId(int repositoryId) {
        this.idGenerator.setNextId(this.inferNextId(repositoryId), repositoryId, RepositoryScope.PULL_REQUEST);
    }

    @Nonnull
    public Page<InternalPullRequest> search(@Nonnull PullRequestSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest, @Nonnull java.util.function.Predicate<? super InternalPullRequest> predicate) {
        return HibernateUtils.initializePage((Page)this.pageQuery(new PullRequestSearchQueryHelper(this.session(), searchCriteria).build(), pageRequest, predicate));
    }

    @Nonnull
    public LongStream streamIds(@Nonnull String descriptionContains) {
        Query query = this.session().createQuery("select id from InternalPullRequest where lower(description) like lower(:pattern) escape '!' order by id asc", Long.class).setParameter("pattern", (Object)LikeQueryHelper.matchesAnywhere(this.session(), descriptionContains)).setCacheMode(CacheMode.IGNORE);
        try (ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);){
            LongStream longStream = NumberBuffer.buffer(ScrollableResultsHelper.scrollableResultsToLongStream(results));
            return longStream;
        }
    }

    @Nonnull
    public Page<InternalPullRequestSummary> summarize(@Nonnull PullRequestSummaryRequest request, @Nonnull PageRequest pageRequest) {
        return HibernatePageUtils.pageQuery(this.buildSummaryQuery(request), (PageRequest)pageRequest).transform(columns -> HibernatePullRequestDao.buildSummary(request.getFields(), columns));
    }

    public InternalPullRequest update(InternalPullRequest entity) {
        return (InternalPullRequest)HibernateUtils.initialize((Object)((InternalPullRequest)super.update((Object)entity)));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    private static InternalPullRequestSummary buildSummary(Set<PullRequestSummaryField> fields, Object[] columns) {
        UnmodifiableIterator iterator = Iterators.forArray((Object[])columns);
        InternalPullRequestSummary.Builder builder = new InternalPullRequestSummary.Builder(((Number)iterator.next()).longValue(), ((Number)iterator.next()).longValue(), (InternalPullRequestRef)iterator.next(), (InternalPullRequestRef)iterator.next());
        if (!fields.isEmpty()) {
            if (fields.contains(PullRequestSummaryField.MERGE_HASH)) {
                builder.mergeHash((String)iterator.next());
            }
            if (fields.contains(PullRequestSummaryField.STATE)) {
                builder.state((PullRequestState)iterator.next());
            }
            if (fields.contains(PullRequestSummaryField.TITLE)) {
                builder.title((String)iterator.next());
            }
            if (fields.contains(PullRequestSummaryField.UPDATED_DATE)) {
                builder.updatedDate((Date)iterator.next());
            }
        }
        InternalPullRequestSummary summary = builder.build();
        summary.initialize();
        return summary;
    }

    private Query<Object[]> buildSummaryQuery(PullRequestSummaryRequest request) {
        Set pullRequestIds = request.getPullRequestIds();
        if (pullRequestIds.size() > 100) {
            throw new IllegalArgumentException("Can only process 100 pull requests at a time");
        }
        StringBuilder hql = new StringBuilder("select p.id, p.scopedId, p.fromRef, p.toRef");
        Set fields = request.getFields();
        boolean joinMerge = false;
        if (!fields.isEmpty()) {
            if (fields.contains(PullRequestSummaryField.MERGE_HASH)) {
                hql.append(", m.hash");
                joinMerge = true;
            }
            if (fields.contains(PullRequestSummaryField.STATE)) {
                hql.append(", p.state");
            }
            if (fields.contains(PullRequestSummaryField.TITLE)) {
                hql.append(", p.title");
            }
            if (fields.contains(PullRequestSummaryField.UPDATED_DATE)) {
                hql.append(", p.updatedDate");
            }
        }
        hql.append(" from InternalPullRequest p ");
        if (joinMerge) {
            hql.append("left outer join InternalPullRequestMergeActivity m on m.pullRequest.id = p.id ");
        }
        hql.append("where p.toRef.repository.id = :repositoryId ");
        if (!pullRequestIds.isEmpty()) {
            hql.append("and p.scopedId in :pullRequestIds ");
        }
        if (request.isOnlyClosed()) {
            hql.append("and p.state != :openState ");
        }
        hql.append("order by p.scopedId asc");
        Query query = this.session().createQuery(hql.toString(), Object[].class).setParameter("repositoryId", (Object)request.getRepositoryId(), (Type)StandardBasicTypes.INTEGER);
        if (!pullRequestIds.isEmpty()) {
            query.setParameter("pullRequestIds", (Object)pullRequestIds);
        }
        if (request.isOnlyClosed()) {
            query.setParameter("openState", (Object)PullRequestState.OPEN);
        }
        return query;
    }

    private Map<PullRequestState, Long> countByState(Query<Object[]> query) {
        EnumMap<PullRequestState, Long> countsByState = new EnumMap<PullRequestState, Long>(PullRequestState.class);
        for (Object[] column : query.list()) {
            countsByState.put((PullRequestState)column[0], (Long)column[1]);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PullRequestState state : PullRequestState.values()) {
            builder.put((Object)state, (Object)countsByState.getOrDefault(state, 0L));
        }
        return builder.build();
    }

    private long inferNextId(int repoId) {
        String hql = "select max(scopedId) from InternalPullRequest where toRef.repository.id = :repoId";
        Query query = this.session().createQuery(hql, Long.class);
        query.setParameter("repoId", (Object)repoId);
        return query.uniqueResultOptional().orElse(0L) + 1L;
    }
}

