/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.participant.AbstractHibernateParticipantDao;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.PullRequestParticipantDao;
import com.atlassian.stash.internal.pull.PullRequestParticipantSearchCriteria;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pullRequestParticipantDao")
public class HibernatePullRequestParticipantDao
extends AbstractHibernateParticipantDao<InternalPullRequestParticipant>
implements PullRequestParticipantDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.asc((String)"role"), HqlQueryBuilder.HqlQueryOrder.asc((String)"id"));

    @Autowired
    public HibernatePullRequestParticipantDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Page<InternalPullRequestParticipant> findByPullRequest(long pullRequestId, @Nonnull PageRequest pageRequest) {
        String hql = "FROM InternalPullRequestParticipant WHERE pullRequest.id = :pullRequest ORDER BY role ASC, id ASC";
        Query query = this.session().createQuery(hql, InternalPullRequestParticipant.class).setParameter("pullRequest", (Object)pullRequestId);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Nullable
    public InternalPullRequestParticipant findByPullRequestAndUser(long pullRequestId, int userId) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(InternalPullRequestParticipant.class).where((HqlQueryBuilder.HqlWhereQueryComponent)HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"pullRequest.id", (Object)pullRequestId), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"user.id", (Object)userId)}));
        return (InternalPullRequestParticipant)HibernateUtils.initialize((Object)((InternalPullRequestParticipant)queryBuilder.buildQuery(this.session()).uniqueResult()));
    }

    @Nonnull
    public Page<InternalApplicationUser> searchUsers(@Nonnull PullRequestParticipantSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select user ").append("from InternalNormalUser user where user.id in (").append("select distinct participant.user.id from InternalPullRequestParticipant as participant");
        Optional fromRepository = searchCriteria.getFromRepository();
        Optional toRepository = searchCriteria.getToRepository();
        if (fromRepository.isPresent() || toRepository.isPresent()) {
            querySql.append(" inner join participant.pullRequest as pull");
            fromRepository.ifPresent(repository -> querySql.append(" with pull.fromRef.repository.id = :fromRepoId"));
            toRepository.ifPresent(repository -> {
                if (fromRepository.isPresent()) {
                    querySql.append(" and");
                } else {
                    querySql.append(" with");
                }
                querySql.append(" pull.toRef.repository.id  = :toRepoId");
            });
        }
        searchCriteria.getRole().ifPresent(role -> querySql.append(" where participant.role = :role"));
        querySql.append(" )");
        querySql.append(" order by user.username asc");
        Query query = this.session().createQuery(querySql.toString(), InternalApplicationUser.class).setCacheable(true).setCacheRegion("query.pullRequestParticipantUsers");
        fromRepository.ifPresent(repository -> query.setParameter("fromRepoId", (Object)repository.getId(), (Type)StandardBasicTypes.INTEGER));
        toRepository.ifPresent(repository -> query.setParameter("toRepoId", (Object)repository.getId(), (Type)StandardBasicTypes.INTEGER));
        searchCriteria.getRole().ifPresent(role -> query.setParameter("role", role));
        return HibernateUtils.initializePage((Page)HibernatePageUtils.pageQuery((Query)query, (PageRequest)pageRequest));
    }

    public int resetLastReviewedCommitByPullRequest(long pullRequestId) {
        return this.session().createQuery("update InternalPullRequestParticipant set lastReviewedCommit = null where pullRequest.id = :pullRequest and lastReviewedCommit != null").setParameter("pullRequest", (Object)pullRequestId, (Type)StandardBasicTypes.LONG).executeUpdate();
    }

    public int resetStatusByPullRequest(long pullRequestId) {
        return this.session().createQuery("update InternalPullRequestParticipant set status = :current where pullRequest.id = :pullRequest and status = :previous").setParameter("current", (Object)PullRequestParticipantStatus.UNAPPROVED).setParameter("pullRequest", (Object)pullRequestId, (Type)StandardBasicTypes.LONG).setParameter("previous", (Object)PullRequestParticipantStatus.NEEDS_WORK).executeUpdate();
    }

    public boolean updateIfLastReviewedCommitMatches(@Nonnull InternalPullRequestParticipant participant) {
        Objects.requireNonNull(participant, "participant");
        String hql = "update InternalPullRequestParticipant as p set p.status = :status, p.lastReviewedCommit = :lastReviewedCommit, p.role = :role where p.id = :id and p.pullRequest.id in (select pr.id from InternalPullRequest as pr where pr = :pullRequest and pr.fromRef.hash = :lastReviewedCommit)";
        int numberOfRecordsUpdated = this.session().createQuery(hql).setParameter("status", (Object)participant.getStatus()).setParameter("lastReviewedCommit", (Object)participant.getLastReviewedCommit()).setParameter("id", (Object)participant.getId()).setParameter("pullRequest", (Object)participant.getPullRequest()).setParameter("role", (Object)participant.getRole()).executeUpdate();
        return numberOfRecordsUpdated == 1;
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

