/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.stash.internal.pull.AbstractPullRequestQueryHelper;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;

public class PullRequestSearchQueryHelper
extends AbstractPullRequestQueryHelper<InternalPullRequest> {
    private static final List<PullRequestOrder> DEFAULT_ORDER = ImmutableList.of((Object)PullRequestOrder.getDefaultOrder());
    private static final String SELECT = "SELECT pr FROM InternalPullRequest pr ";
    private final StringBuilder selectBuilder = new StringBuilder("SELECT pr FROM InternalPullRequest pr ");
    private String orderBy;

    public PullRequestSearchQueryHelper(@Nonnull Session session, @Nonnull PullRequestSearchCriteria criteria) {
        super(session, criteria);
        this.setOrder(criteria.getOrders().isEmpty() ? DEFAULT_ORDER : criteria.getOrders());
    }

    @Override
    public String toString() {
        return String.valueOf(this.selectBuilder) + this.getJoinString() + this.getConstraintString() + this.orderBy;
    }

    private void setOrder(List<PullRequestOrder> orders) {
        LinkedHashSet orderClauses = new LinkedHashSet();
        orders.forEach(order -> {
            switch (order) {
                case NEWEST: {
                    orderClauses.add("pr.updatedDate DESC");
                    break;
                }
                case OLDEST: {
                    orderClauses.add("pr.updatedDate ASC");
                    break;
                }
                case DRAFT_STATUS: {
                    orderClauses.add("pr.phase ASC");
                    break;
                }
                case PARTICIPANT_STATUS: {
                    orderClauses.add("st.weight ASC");
                    this.selectBuilder.append(", InternalPullRequestParticipantStatusType st ");
                    this.addConstraint("p0.status = st.id ");
                    break;
                }
                case CLOSED_DATE: {
                    orderClauses.add("CASE WHEN pr.closedDate IS NULL THEN 0 ELSE 1 END, pr.closedDate DESC");
                }
            }
        });
        Object orderClause = StringUtils.join(orderClauses, (String)", ");
        if (!((String)orderClause).contains("pr.updatedDate")) {
            orderClause = (String)orderClause + ", pr.updatedDate DESC";
        }
        this.orderBy = "ORDER BY " + (String)orderClause;
    }
}

