/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.automerge.AutoMergeRequestDao;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeRequest;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.util.NumberBuffer;
import com.atlassian.stash.internal.util.ScrollableResultsHelper;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="autoMergeRequestDao")
public class HibernateAutoMergeRequestDao
extends AbstractHibernateDao<Long, InternalAutoMergeRequest>
implements AutoMergeRequestDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"pullRequestId"));

    @Autowired
    public HibernateAutoMergeRequestDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void deleteByIds(@Nonnull Set<Long> requestIds) {
        Objects.requireNonNull(requestIds, "requestIds");
        for (List partition : Iterables.partition(requestIds, (int)100)) {
            this.session().createQuery("DELETE from InternalAutoMergeRequest WHERE id in (:ids)").setParameterList("ids", (Collection)partition).executeUpdate();
        }
    }

    public boolean deleteByPullRequest(@Nonnull InternalPullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        String hql = "DELETE FROM InternalAutoMergeRequest WHERE id = :id";
        return this.session().createQuery(hql).setParameter("id", (Object)pullRequest.getGlobalId()).executeUpdate() > 0;
    }

    @Nonnull
    public Page<InternalAutoMergeRequest> findByRepository(int repositoryId, @Nonnull Date createdBy, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(createdBy, "createdBy");
        Objects.requireNonNull(pageRequest, "pageRequest");
        String hql = "SELECT a FROM InternalAutoMergeRequest a inner join fetch a.pullRequest p WHERE p.toRef.repository.id = :repositoryId AND a.createdDate <= :createdBy ORDER BY a.id";
        Query query = this.session().createQuery(hql, InternalAutoMergeRequest.class).setParameter("repositoryId", (Object)repositoryId).setParameter("createdBy", (Object)createdBy);
        return this.pageQuery(query, pageRequest);
    }

    @Nonnull
    public List<Long> findIdsByRepository(int repositoryId, long offsetId, int limit) {
        String hql = "SELECT id FROM InternalAutoMergeRequest WHERE pullRequest.toRef.repository.id = :repositoryId AND id > :id ORDER BY id";
        Query query = this.session().createQuery(hql, Long.class).setParameter("repositoryId", (Object)repositoryId).setParameter("id", (Object)offsetId).setMaxResults(limit);
        return HibernateUtils.initializeList((List)query.getResultList());
    }

    public InternalAutoMergeRequest getById(Long id) {
        return (InternalAutoMergeRequest)HibernateUtils.initialize((Object)((InternalAutoMergeRequest)super.getById((Serializable)id)));
    }

    @Nonnull
    public InternalAutoMergeRequest getByPullRequest(@Nonnull InternalPullRequest pullRequest) {
        return this.getById(Objects.requireNonNull(pullRequest, "pullRequest").getGlobalId());
    }

    @Nonnull
    public IntStream streamRepositoryIds() {
        String hql = "SELECT DISTINCT pullRequest.toRef.repository.id AS repoId FROM InternalAutoMergeRequest ORDER BY repoId";
        Query query = this.session().createQuery(hql, Integer.class).setFetchSize(100).setCacheMode(CacheMode.IGNORE);
        try (ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);){
            IntStream intStream = NumberBuffer.buffer(ScrollableResultsHelper.scrollableResultsToIntStream(results));
            return intStream;
        }
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

