/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.automerge.AutoMergeSettingsDao;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeSettings;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scope.Scopeable;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="autoMergeSettingsDao")
public class HibernateAutoMergeSettingsDao
extends AbstractHibernateDao<Long, InternalAutoMergeSettings>
implements AutoMergeSettingsDao {
    private static final int BULK_DELETE_MAX_SIZE = 1000;

    @Autowired
    public HibernateAutoMergeSettingsDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteByRepositoryIds(@Nonnull Set<Integer> repositoryIds) {
        Objects.requireNonNull(repositoryIds, "repositoryIds");
        if (repositoryIds.isEmpty()) {
            return 0;
        }
        if (repositoryIds.size() > 1000) {
            throw new IllegalArgumentException("Repository IDs cannot exceed 1000 entries");
        }
        String hql = "DELETE FROM InternalAutoMergeSettings WHERE scope.class = :scopeType AND scope.id in (:scopeIds)";
        return this.session().createQuery(hql).setParameter("scopeType", (Object)InternalRepository.class.getName()).setParameter("scopeIds", repositoryIds).executeUpdate();
    }

    public boolean deleteByScope(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        String hql = "DELETE FROM InternalAutoMergeSettings WHERE scope = :scope";
        return this.session().createQuery(hql).setParameter("scope", (Object)Scopeable.fromScope((Scope)scope)).executeUpdate() > 0;
    }

    @Nullable
    public InternalAutoMergeSettings findByScope(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() == ScopeType.GLOBAL) {
            return null;
        }
        String hql = "FROM InternalAutoMergeSettings WHERE scope = :scope";
        return (InternalAutoMergeSettings)HibernateUtils.initialize((Object)((InternalAutoMergeSettings)this.session().createQuery(hql, InternalAutoMergeSettings.class).setParameter("scope", (Object)Scopeable.fromScope((Scope)scope)).uniqueResult()));
    }

    @Nullable
    public InternalAutoMergeSettings findInheritedByScopes(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() == ScopeType.GLOBAL) {
            return null;
        }
        Collection<Scopeable> scopeables = HibernateAutoMergeSettingsDao.getInheritedScopeables(scope);
        String hql = "FROM InternalAutoMergeSettings WHERE scope IN :scopes order by scope_type desc";
        return (InternalAutoMergeSettings)HibernateUtils.initialize((Object)((InternalAutoMergeSettings)this.session().createQuery(hql, InternalAutoMergeSettings.class).setCacheable(true).setCacheRegion("query.autoMergeSettingsByScope").setParameterList("scopes", scopeables).setMaxResults(1).uniqueResult()));
    }

    private static Collection<Scopeable> getInheritedScopeables(Scope scope) {
        return (Collection)scope.accept((ScopeVisitor)new ScopeVisitor<Set<Scopeable>>(){

            public Set<Scopeable> visit(@Nonnull ProjectScope scope) {
                return ImmutableSet.of((Object)Scopeable.fromScope((Scope)scope));
            }

            public Set<Scopeable> visit(@Nonnull RepositoryScope scope) {
                return ImmutableSet.of((Object)Scopeable.fromScope((Scope)scope), (Object)Scopeable.fromScope((Scope)Scopes.project((Project)scope.getProject())));
            }
        });
    }
}

