/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftRequestDao;
import com.atlassian.stash.internal.pull.comment.drift.InternalDriftRequest;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="driftRequestDao")
public class HibernateCommentDriftRequestDao
implements CommentDriftRequestDao {
    private final SessionFactory sessionFactory;

    @Autowired
    public HibernateCommentDriftRequestDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Nonnull
    public InternalDriftRequest create(@Nonnull InternalDriftRequest request) {
        this.session().save((Object)request);
        return request;
    }

    public void deleteAll(@Nonnull List<InternalDriftRequest> requests) {
        Chainable.chain(requests).transform(InternalDriftRequest::getId).filter(Objects::nonNull).partition(100).filter(ids -> !ids.isEmpty()).forEach(ids -> this.session().createQuery("delete from InternalDriftRequest where id in (:ids)").setParameterList("ids", (Collection)ids).executeUpdate());
    }

    @Nonnull
    public List<InternalDriftRequest> findAll() {
        return HibernateUtils.initializeList((List)this.session().createQuery("from InternalDriftRequest order by id asc").list());
    }

    @Nonnull
    public List<InternalDriftRequest> findByGlobalId(long globalId) {
        return HibernateUtils.initializeList((List)this.session().createQuery("from InternalDriftRequest r where r.pullRequest.id = :globalId order by id asc").setParameter("globalId", (Object)globalId).list());
    }

    @Nonnull
    public List<InternalPullRequest> findPendingPullRequests(int maxAttempts) {
        return HibernateUtils.initializeList((List)this.session().createQuery("select p from InternalPullRequest p where p.id in (select distinct r.pullRequest.id from InternalDriftRequest r where r.attempts <= :maxAttempts)").setParameter("maxAttempts", (Object)maxAttempts).list());
    }

    public InternalDriftRequest getById(@Nonnull Long id) {
        InternalDriftRequest request = (InternalDriftRequest)this.session().get(InternalDriftRequest.class, (Serializable)id);
        return (InternalDriftRequest)HibernateUtils.initialize((Object)request);
    }

    public void updateAttempts(@Nonnull InternalDriftRequest request, int attempts) {
        this.session().createQuery("update InternalDriftRequest set attempts = :attempts where id = :id").setParameter("attempts", (Object)attempts).setParameter("id", (Object)request.getId()).executeUpdate();
        this.session().evict((Object)request);
    }

    private Session session() {
        return this.sessionFactory.getCurrentSession();
    }
}

