/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.reviewer;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.reviewer.InternalReviewerGroup;
import com.atlassian.stash.internal.pull.reviewer.ReviewerGroupDao;
import com.atlassian.stash.internal.scope.Scopeable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository(value="reviewerGroupDao")
public class HibernateReviewerGroupDao
extends AbstractHibernateDao<Long, InternalReviewerGroup>
implements ReviewerGroupDao {
    public HibernateReviewerGroupDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Page<InternalReviewerGroup> findByName(@Nonnull Scope s, @Nonnull String name, @Nonnull PageRequest pageRequest) {
        Collection<Scopeable> scopeables = HibernateReviewerGroupDao.getInheritedScopeables(s);
        String hql = "FROM InternalReviewerGroup WHERE scope IN :scopes AND lower(name) LIKE lower(:name) ORDER BY scope_type ASC, name ASC";
        Query query = this.session().createQuery(hql, InternalReviewerGroup.class).setParameter("scopes", scopeables).setParameter("name", (Object)(name + "%"));
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Nonnull
    public Page<InternalReviewerGroup> findInheritedByScopes(@Nonnull Scope s, @Nonnull PageRequest pageRequest) {
        Collection<Scopeable> scopeables = HibernateReviewerGroupDao.getInheritedScopeables(s);
        String hql = "FROM InternalReviewerGroup WHERE scope IN :scopes order by scope_type asc, name asc";
        Query query = this.session().createQuery(hql, InternalReviewerGroup.class).setParameter("scopes", scopeables);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Nonnull
    public InternalReviewerGroup getById(Long id) {
        return (InternalReviewerGroup)HibernateUtils.initialize((Object)((InternalReviewerGroup)super.getById((Serializable)id)));
    }

    @Nonnull
    public Set<InternalReviewerGroup> getByIdsAndScope(@Nonnull Set<Long> ids, @Nonnull Scope scope) {
        HashSet<InternalReviewerGroup> groups = new HashSet<InternalReviewerGroup>();
        Collection<Scopeable> scopes = HibernateReviewerGroupDao.getInheritedScopeables(scope);
        for (List partition : Iterables.partition(ids, (int)100)) {
            String hql = "FROM InternalReviewerGroup WHERE id IN (:ids) AND scope IN (:scopes)";
            List query = HibernateUtils.initializeList((List)this.session().createQuery(hql, InternalReviewerGroup.class).setParameter("ids", (Object)partition).setParameter("scopes", scopes).list());
            groups.addAll(query);
        }
        return groups;
    }

    public InternalReviewerGroup getByName(@Nonnull Scope s, @Nonnull String name) {
        Scopeable scope = Scopeable.fromScope((Scope)s);
        String hql = "FROM InternalReviewerGroup WHERE scope = :scope AND lower(name) = lower(:name)";
        return (InternalReviewerGroup)HibernateUtils.initialize((Object)((InternalReviewerGroup)this.session().createQuery(hql, InternalReviewerGroup.class).setParameter("scope", (Object)scope).setParameter("name", (Object)name).uniqueResult()));
    }

    private static Collection<Scopeable> getInheritedScopeables(Scope scope) {
        return (Collection)scope.accept((ScopeVisitor)new ScopeVisitor<Set<Scopeable>>(){

            public Set<Scopeable> visit(@Nonnull ProjectScope scope) {
                return ImmutableSet.of((Object)Scopeable.fromScope((Scope)scope));
            }

            public Set<Scopeable> visit(@Nonnull RepositoryScope scope) {
                return ImmutableSet.of((Object)Scopeable.fromScope((Scope)scope), (Object)Scopeable.fromScope((Scope)Scopes.project((Project)scope.getProject())));
            }
        });
    }
}

