/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.template;

import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.template.InternalPullRequestTemplate;
import com.atlassian.stash.internal.pull.template.PullRequestTemplateDao;
import com.atlassian.stash.internal.scope.Scopeable;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository(value="pullRequestTemplateDao")
public class HibernatePullRequestTemplateDao
extends AbstractHibernateDao<Long, InternalPullRequestTemplate>
implements PullRequestTemplateDao {
    public HibernatePullRequestTemplateDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public boolean deleteByScope(@Nonnull Scope s) {
        Scopeable scope = Scopeable.fromScope((Scope)s);
        String hql = "DELETE FROM InternalPullRequestTemplate WHERE " + (scope == null ? "scope is null" : "scope = :scope");
        Query query = this.session().createQuery(hql);
        if (scope != null) {
            query.setParameter("scope", (Object)scope);
        }
        return query.executeUpdate() > 0;
    }

    @Nonnull
    public Optional<InternalPullRequestTemplate> findByScope(@Nonnull Scope s) {
        Scopeable scope = Scopeable.fromScope((Scope)s);
        String hql = "FROM InternalPullRequestTemplate WHERE " + (scope == null ? "scope is null" : "scope = :scope");
        Query query = this.session().createQuery(hql, InternalPullRequestTemplate.class);
        if (scope != null) {
            query.setParameter("scope", (Object)scope);
        }
        return query.uniqueResultOptional().map(HibernateUtils::initialize);
    }

    @Nonnull
    public InternalPullRequestTemplate setTemplate(@Nonnull InternalPullRequestTemplate template) {
        this.findByScope(template.getScope()).ifPresent(existing -> this.deleteByScope(template.getScope()));
        return (InternalPullRequestTemplate)HibernateUtils.initialize((Object)((InternalPullRequestTemplate)this.create(template)));
    }
}

