/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.dmz.repository.RepositoryRefChangeActivity;
import com.atlassian.bitbucket.dmz.repository.RepositoryRefChangeActivityBranchesRequest;
import com.atlassian.bitbucket.dmz.repository.RepositoryRefChangeActivitySearchRequest;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.SatiableConsumer;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.activity.AbstractHibernateActivityDao;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionCommentActivity;
import com.atlassian.stash.internal.dashboard.RecentPush;
import com.atlassian.stash.internal.dashboard.SimpleRecentPush;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryActivity;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@org.springframework.stereotype.Repository(value="repositoryActivityDao")
@DefaultApplicationMode
public class HibernateRepositoryActivityDao
extends AbstractHibernateActivityDao<InternalRepositoryActivity>
implements RepositoryActivityDao {
    private static final String BRANCH_PREFIX = "refs/heads/";
    private final int postgresRecentActivityMaxResults;

    @Autowired
    public HibernateRepositoryActivityDao(SessionFactory sessionFactory, @Value(value="${hibernate.postgres.repository.recent-activity.max.results:100}") int postgresRecentActivityMaxResults) {
        super(sessionFactory);
        this.postgresRecentActivityMaxResults = Math.min(10000, Math.max(100, postgresRecentActivityMaxResults));
    }

    public int deleteByComment(long commentId) {
        return this.session().createQuery("DELETE FROM InternalCommitDiscussionCommentActivity WHERE comment.id = :commentId").setParameter("commentId", (Object)commentId, (Type)StandardBasicTypes.LONG).executeUpdate();
    }

    public int deleteByRepository(int repositoryId) {
        return this.maybeBulkDelete("FROM InternalRepositoryActivity WHERE repository.id = :repositoryId", (Map)ImmutableMap.of((Object)"repositoryId", (Object)repositoryId));
    }

    @Nonnull
    public Page<MinimalRef> findBranchesWithRefChangeActivities(@Nonnull RepositoryRefChangeActivityBranchesRequest request, @Nonnull PageRequest pageRequest) {
        Query query;
        int repositoryId = request.getRepository().getId();
        if (request.getFilterText() == null) {
            String hql = "SELECT distinct rc.refId FROM InternalRepositoryPushActivity rpa JOIN rpa.refChanges rc WHERE rpa.repository.id = :repositoryId AND rc.refId LIKE :filter ORDER BY rc.refId";
            query = this.session().createQuery(hql, String.class).setParameter("filter", (Object)"refs/heads/%").setParameter("repositoryId", (Object)repositoryId);
        } else {
            String hql = "SELECT rc.refId FROM InternalRepositoryPushActivity rpa JOIN rpa.refChanges rc WHERE rpa.repository.id = :repositoryId AND LOWER(rc.refId) LIKE :prefixFilter GROUP BY rc.refId ORDER BY ";
            query = this.addOrderAndCreateQueryForFindBranches(hql, request.getFilterText().toLowerCase(Locale.ROOT), repositoryId);
        }
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest).transform(id -> ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().displayId(id.substring(11))).id(id)).type((RefType)StandardRefType.BRANCH).build()));
    }

    public InternalCommitDiscussionCommentActivity findByComment(long commentId) {
        Query query = this.session().createQuery("FROM InternalCommitDiscussionCommentActivity WHERE comment.id = :commentId AND commentAction = :commentAction", InternalCommitDiscussionCommentActivity.class).setParameter("commentId", (Object)commentId).setParameter("commentAction", (Object)CommentAction.ADDED);
        return (InternalCommitDiscussionCommentActivity)HibernateUtils.initialize((Object)((InternalCommitDiscussionCommentActivity)query.uniqueResult()));
    }

    @Nullable
    public Date findMostRecentActivityTime(int repositoryId) {
        String hql = "SELECT ra.createdDate FROM InternalRepositoryActivity ra WHERE ra.repository.id = :repositoryId AND (ra.triggerId IS NULL OR ra.triggerId <> :unknownTriggerId) ORDER BY ra.createdDate DESC";
        Query baseQuery = this.session().createQuery(hql, Date.class).setParameter("repositoryId", (Object)repositoryId).setParameter("unknownTriggerId", (Object)StandardRepositoryHookTrigger.UNKNOWN.getId());
        if (this.isPostgres()) {
            this.log.debug("Database is Postgres, finding most recent activity time using limit of {} for repository (id={})", (Object)this.postgresRecentActivityMaxResults, (Object)repositoryId);
            try (ScrollableResults results = baseQuery.setFetchSize(1).setMaxResults(this.postgresRecentActivityMaxResults).scroll(ScrollMode.FORWARD_ONLY);){
                Date date = results.next() ? results.getDate(0) : null;
                return date;
            }
        }
        return (Date)baseQuery.setMaxResults(1).uniqueResult();
    }

    public void findRecentPushesForUser(int userId, @Nonnull Date pushedSince, @Nonnull SatiableConsumer<RecentPush> consumer) {
        Query query = this.session().createQuery("SELECT rpa.createdDate, rpa.repository.id, rc.refId, rc.fromHash, rc.toHash, rc.type FROM InternalRepositoryPushActivity rpa JOIN rpa.refChanges rc WHERE rpa.createdDate > :pushedSince AND rpa.user.id = :userId AND rpa.triggerId = :pushTrigger AND rc.type != :deleteType AND NOT EXISTS (FROM InternalPullRequest pr WHERE pr.fromRef.repository.id = rpa.repository.id AND pr.fromRef.id = rc.refId AND (pr.closedDate IS NULL OR pr.closedDate > rpa.createdDate)) ORDER BY rpa.createdDate DESC, rc.refId").setParameter("deleteType", (Object)RefChangeType.DELETE).setParameter("pushedSince", (Object)pushedSince, (Type)StandardBasicTypes.DATE).setParameter("pushTrigger", (Object)StandardRepositoryHookTrigger.REPO_PUSH.getId(), (Type)StandardBasicTypes.STRING).setParameter("userId", (Object)userId, (Type)StandardBasicTypes.INTEGER);
        this.scrollQuery(query, scroll -> consumer.accept((Object)new SimpleRecentPush(scroll.getDate(0), (Repository)((InternalRepository)this.session().get(InternalRepository.class, (Serializable)scroll.getInteger(1))), scroll.getString(2), scroll.getString(3), scroll.getString(4), (RefChangeType)scroll.get(5))));
    }

    @Nonnull
    public Page<RepositoryRefChangeActivity> findRefChangeActivities(@Nonnull RepositoryRefChangeActivitySearchRequest request, @Nonnull PageRequest pageRequest) {
        String hql = "SELECT new com.atlassian.stash.internal.repository.InternalRepositoryRefChangeActivity(rpa.createdDate, rpa.id, rpa.type, a.user, rpa.repository, rc, rpa.triggerId)FROM InternalRepositoryPushActivity rpa JOIN rpa.refChanges rc JOIN InternalActivity a ON rpa.id = a.id WHERE rpa.repository.id = :repositoryId AND (:refId is null OR rc.refId = :refId) ORDER BY rpa.createdDate DESC, rc.refId";
        Query query = this.session().createQuery(hql, RepositoryRefChangeActivity.class).setParameter("repositoryId", (Object)request.getRepository().getId()).setParameter("refId", (Object)request.getRefId());
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    public InternalRepositoryActivity update(InternalRepositoryActivity entity) {
        throw new UnsupportedOperationException("RepositoryActivities are immutable and cannot be updated.");
    }

    private Query<String> addOrderAndCreateQueryForFindBranches(String hql, String filterText, int repositoryId) {
        Query query;
        if (this.isHsql()) {
            hql = (String)hql + "rc.refId";
            query = this.session().createQuery((String)hql, String.class).setParameter("prefixFilter", (Object)(BRANCH_PREFIX + filterText + "%")).setParameter("repositoryId", (Object)repositoryId);
        } else {
            hql = (String)hql + "(CASE WHEN LOWER(rc.refId) LIKE :exactFilter THEN 1 WHEN LOWER(rc.refId) LIKE :prefixFilter THEN 2 END), rc.refId";
            query = this.session().createQuery((String)hql, String.class).setParameter("exactFilter", (Object)(BRANCH_PREFIX + filterText)).setParameter("prefixFilter", (Object)(BRANCH_PREFIX + filterText + "%")).setParameter("repositoryId", (Object)repositoryId);
        }
        return query;
    }
}

