/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryAlias;
import com.atlassian.stash.internal.repository.RepositoryAliasDao;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryAliasDao")
public class HibernateRepositoryAliasDao
extends AbstractHibernateDao<Long, InternalRepositoryAlias>
implements RepositoryAliasDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.desc((String)"id"));
    private static final int MAX_ATTEMPTS = 3;
    private static final int MAX_RESULTS = 500;

    public HibernateRepositoryAliasDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public InternalRepositoryAlias create(@Nonnull InternalRepositoryAlias alias) {
        return (InternalRepositoryAlias)this.retryOnConstraintViolation(3, () -> {
            InternalRepositoryAlias current = this.getBySlug(alias.getProjectKey(), alias.getSlug());
            if (current != null) {
                this.session().delete((Object)current);
                this.session().flush();
            }
            return (InternalRepositoryAlias)super.create((Object)alias);
        });
    }

    public void createAllForProject(@Nonnull InternalProject project, @Nonnull String aliasKey) {
        this.retryOnConstraintViolation(3, () -> {
            int count;
            Session session = this.session();
            session.createQuery("delete from InternalRepositoryAlias where projectKey = :pkey and slug in (select slug from InternalRepository where project.id = :projectId)").setParameter("pkey", (Object)InternalProject.keyify((String)aliasKey)).setParameter("projectId", (Object)project.getId()).executeUpdate();
            do {
                List repos = session.createQuery("from InternalRepository as r where r.id not in (select repository.id from InternalRepositoryAlias where repository.project.id = :projectId and projectKey = :pkey) and r.project.id = :projectId").setParameter("pkey", (Object)InternalProject.keyify((String)aliasKey)).setParameter("projectId", (Object)project.getId()).setMaxResults(500).list();
                ArrayList<InternalRepositoryAlias> aliases = new ArrayList<InternalRepositoryAlias>(repos.size());
                for (InternalRepository repository : repos) {
                    InternalRepositoryAlias alias = new InternalRepositoryAlias.Builder(repository).project(aliasKey).build();
                    aliases.add(alias);
                    session.saveOrUpdate((Object)alias);
                }
                count = repos.size();
                session.flush();
                aliases.forEach(arg_0 -> ((Session)session).evict(arg_0));
                repos.forEach(arg_0 -> ((Session)session).evict(arg_0));
            } while (count >= 500);
        });
    }

    public void deleteBySlug(@Nonnull String projectKey, @Nonnull String slug) {
        this.session().createQuery("delete from InternalRepositoryAlias where projectKey = :pkey and slug = :slug").setParameter("pkey", (Object)InternalProject.keyify((String)projectKey)).setParameter("slug", (Object)StringUtils.lowerCase((String)slug, (Locale)Locale.US)).executeUpdate();
    }

    @Nullable
    public InternalRepositoryAlias getBySlug(@Nonnull String projectKey, @Nonnull String slug) {
        return (InternalRepositoryAlias)HibernateUtils.initialize((Object)((InternalRepositoryAlias)this.session().createQuery("from InternalRepositoryAlias where projectKey = :pkey and slug = :slug", InternalRepositoryAlias.class).setParameter("pkey", (Object)InternalProject.keyify((String)projectKey)).setParameter("slug", (Object)StringUtils.lowerCase((String)slug, (Locale)Locale.US)).uniqueResult()));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

