/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.dmz.repository.RepositoryCallback;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.SatiableConsumer;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.CommentThreadDao;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositoryOrder;
import com.atlassian.stash.internal.repository.RepositoryScopedIdGenerator;
import com.atlassian.stash.internal.repository.RepositorySearchCriteria;
import com.atlassian.stash.internal.server.InternalDataStore;
import com.google.common.collect.Iterators;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.stream.Streams;
import org.hibernate.CacheMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Repository(value="repositoryDao")
public class HibernateRepositoryDao
extends AbstractHibernateDao<Integer, InternalRepository>
implements RepositoryDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.asc((String)"name").ignoreCase(), HqlQueryBuilder.HqlQueryOrder.asc((String)"id"));
    private final RepositoryActivityDao activityDao;
    private final CommentThreadDao commentThreadDao;
    private final RepositoryScopedIdGenerator idGenerator;

    @Autowired
    public HibernateRepositoryDao(SessionFactory sessionFactory, RepositoryActivityDao activityDao, CommentThreadDao commentThreadDao, RepositoryScopedIdGenerator idGenerator) {
        super(sessionFactory);
        this.activityDao = activityDao;
        this.commentThreadDao = commentThreadDao;
        this.idGenerator = idGenerator;
    }

    public long countAll() {
        String query = "select count(*) from InternalRepository";
        return (Long)this.session().createQuery(query, Long.class).uniqueResult();
    }

    @Nonnull
    public Map<Integer, Long> countAllByPartition() {
        String query = "select partition, count(id) from InternalRepository group by partition order by partition";
        HashMap<Integer, Long> stats = new HashMap<Integer, Long>();
        this.scrollQuery(this.session().createQuery(query), result -> {
            Integer partitionId = result.getInteger(0);
            Long repoCount = result.getLong(1);
            stats.put(partitionId == null ? -1 : partitionId, repoCount == null ? 0L : repoCount);
        });
        return stats;
    }

    @Nonnull
    public Map<String, Long> countByHierarchies(Set<String> hierarchyIds) {
        String hql = "SELECT r.hierarchyId, count(r.hierarchyId) FROM InternalRepository r WHERE r.hierarchyId IN (:hierarchyIds) GROUP BY r.hierarchyId";
        return (Map)this.session().createQuery(hql, Object[].class).setParameter("hierarchyIds", hierarchyIds).stream().collect(MoreCollectors.toImmutableMap(result -> (String)result[0], result -> (Long)result[1]));
    }

    public long countByHierarchy(String hierarchyId) {
        String query = "select count(*) from InternalRepository where hierarchyId = :hierarchyId";
        return (Long)this.session().createQuery(query, Long.class).setParameter("hierarchyId", (Object)hierarchyId).uniqueResult();
    }

    public long countByProject(int projectId) {
        String query = "select count(*) from InternalRepository where project.id = :projectId";
        return (Long)this.session().createQuery(query, Long.class).setParameter("projectId", (Object)projectId).uniqueResult();
    }

    public long countPublicByProject(int projectId) {
        String query = "select count(*) from InternalRepository where project.id = :projectId and publiclyAccessible = :publiclyAccessible";
        return (Long)this.session().createQuery(query, Long.class).setParameter("projectId", (Object)projectId).setParameter("publiclyAccessible", (Object)true).setCacheable(true).setCacheRegion("query.publicRepositoryCountByProject").uniqueResult();
    }

    @Nonnull
    public InternalRepository create(InternalRepository entity) {
        InternalRepository created = (InternalRepository)super.create((Object)entity);
        this.session().flush();
        this.idGenerator.prepare(created.getId());
        return created;
    }

    public void delete(InternalRepository entity) {
        this.cleanup(entity.getId());
        super.delete((Object)entity);
    }

    public void deleteById(Integer id) {
        this.cleanup(id);
        super.deleteById((Serializable)id);
    }

    @Nonnull
    public Page<InternalRepository> findAll(PageRequest pageRequest) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest));
    }

    @Nonnull
    public Page<InternalRepository> findAll(PageRequest pageRequest, Predicate<? super InternalRepository> predicate) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalRepository> findByHierarchy(@Nonnull InternalRepository repository, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        String hql = "from InternalRepository where id != :repositoryId and hierarchyId = :hierarchyId order by project.key, lower(name)";
        Query query = this.session().createQuery(hql, InternalRepository.class).setParameter("repositoryId", (Object)repository.getId(), (Type)StandardBasicTypes.INTEGER).setParameter("hierarchyId", (Object)repository.getHierarchyId()).setCacheable(true).setCacheRegion("query.repositoriesByHierarchy");
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalRepository> findByHierarchyId(@Nonnull String hierarchyId, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("from InternalRepository where hierarchyId = :hierarchyId order by id").setParameter("hierarchyId", (Object)hierarchyId);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Nonnull
    public Page<InternalRepository> findByOrigin(@Nonnull InternalRepository origin, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(InternalRepository.class).where(HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"origin", (Object)origin)).orderBy(this.getImplicitOrder());
        return HibernateUtils.initializePage((Page)this.pageQuery(queryBuilder.buildQuery(this.session()), pageRequest, predicate));
    }

    public InternalRepository findByOriginInProject(@Nonnull InternalRepository origin, int projectId) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(InternalRepository.class).where((HqlQueryBuilder.HqlWhereQueryComponent)HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"origin", (Object)origin), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"project.id", (Object)projectId), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"slug", (Object)origin.getSlug())}));
        return (InternalRepository)HibernateUtils.initialize((Object)((InternalRepository)queryBuilder.buildQuery(this.session()).uniqueResult()));
    }

    @Nonnull
    public Page<InternalRepository> findByOwner(int ownerId, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        String hql = "select r from InternalRepository r, InternalPersonalProject p where r.project = p and p.owner.id = :ownerId order by lower(r.name)";
        Query query = this.session().createQuery(hql, InternalRepository.class).setParameter("ownerId", (Object)ownerId, (Type)StandardBasicTypes.INTEGER);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalRepository> findByProjectId(int projectId, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        String hql = "from InternalRepository\nwhere project.id = :projectId\n";
        Query query = this.session().createQuery(hql, InternalRepository.class).setParameter("projectId", (Object)projectId);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalRepository> findByProjectKey(@Nonnull String projectKey, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        String hql = "from InternalRepository where project.key = :projectKey order by upper(name)";
        Query query = this.session().createQuery(hql, InternalRepository.class).setParameter("projectKey", (Object)InternalProject.keyify((String)projectKey));
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalRepository> findByScmId(@Nonnull String scmId, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("from InternalRepository where scmId = :scmId").setParameter("scmId", (Object)scmId);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    public InternalRepository getById(Integer id) {
        return (InternalRepository)HibernateUtils.initialize((Object)((InternalRepository)super.getById((Serializable)id)));
    }

    @Nonnull
    public List<InternalRepository> getByIds(@Nonnull Collection<Integer> ids) {
        return Streams.of((Iterator)Iterators.partition(ids.iterator(), (int)100)).map(x$0 -> super.getByIds(x$0)).flatMap(Collection::stream).map(HibernateUtils::initialize).toList();
    }

    @Nullable
    public InternalRepository getBySlug(@Nonnull String projectKey, @Nonnull String slug) {
        String hql = "from InternalRepository where project.key = :projectKey and slug = :slug";
        return (InternalRepository)HibernateUtils.initialize((Object)((InternalRepository)this.session().createQuery(hql).setParameter("slug", (Object)InternalRepository.slugify((String)slug)).setParameter("projectKey", (Object)InternalProject.keyify((String)projectKey)).setCacheable(true).setCacheRegion("query.repositoryBySlug").uniqueResult()));
    }

    @Nonnull
    public List<Integer> getForkIds(@Nonnull InternalRepository repository) {
        String hql = "select id from InternalRepository where origin = :origin";
        return this.session().createQuery(hql, Integer.class).setParameter("origin", (Object)repository).list();
    }

    @Nonnull
    public List<Integer> getIds() {
        return this.session().createQuery("select id from InternalRepository order by id", Integer.class).list();
    }

    @Nonnull
    public List<Integer> getIdsByDataStore(@Nullable InternalDataStore store, @Nullable Boolean remote) {
        Query query = this.session().createQuery("select id from InternalRepository where " + (store == null ? "dataStore.id is null " : "dataStore.id = :storeId ") + (String)(remote == null ? "" : "and partition is " + (remote != false ? "not null " : "null ")) + "order by id asc", Integer.class);
        if (store != null) {
            query.setParameter("storeId", (Object)store.getId());
        }
        return query.list();
    }

    @Nonnull
    public Page<InternalRepository> getOrderedById(int afterId, @Nonnull PageRequest pageRequest) {
        String hql = "from InternalRepository where id > :afterId order by id";
        Query query = this.session().createQuery(hql, InternalRepository.class).setParameter("afterId", (Object)afterId);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Nonnull
    public Page<InternalRepository> search(@Nonnull RepositorySearchCriteria searchCriteria, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(InternalRepository.class);
        if (this.requiresProjectJoin(searchCriteria)) {
            queryBuilder.joinFetch("project", HqlQueryBuilder.JoinType.INNER_JOIN);
        }
        HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
        HibernateRepositoryDao.maybeRestrictProjectKey(searchCriteria, conditionals);
        HibernateRepositoryDao.maybeRestrictProjectName(searchCriteria, conditionals);
        HibernateRepositoryDao.maybeRestrictRepositoryName(searchCriteria, conditionals);
        HibernateRepositoryDao.maybeRestrictArchivedRepository(searchCriteria, conditionals);
        HibernateRepositoryDao.maybeRestrictVisibility(searchCriteria, conditionals);
        HibernateRepositoryDao.maybeRestrictState(searchCriteria, conditionals);
        if (!conditionals.isEmpty()) {
            queryBuilder.where((HqlQueryBuilder.HqlWhereQueryComponent)conditionals);
        }
        searchCriteria.getOrder().apply(queryBuilder);
        return HibernateUtils.initializePage((Page)this.pageQuery(queryBuilder.buildQuery(this.session()), pageRequest, predicate));
    }

    public void streamAll(@Nonnull RepositoryCallback callback) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(InternalRepository.class).orderBy(this.getImplicitOrder());
        Query query = queryBuilder.buildQuery(this.session()).setCacheMode(CacheMode.GET).setFetchSize(100);
        this.streamRepositories((Query<InternalRepository>)query, callback);
    }

    public void streamByRemote(boolean remote, @Nonnull RepositoryCallback callback) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(InternalRepository.class).where(remote ? HqlQueryBuilder.HqlWhereQueryComponent.isNotNull((String)"partition") : HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"partition")).orderBy(this.getImplicitOrder());
        Query query = queryBuilder.buildQuery(this.session()).setCacheMode(CacheMode.GET).setFetchSize(100);
        this.streamRepositories((Query<InternalRepository>)query, callback);
    }

    public void streamReadOnly(@Nonnull RepositoryCallback callback) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(InternalRepository.class).where(HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"readOnly", (Object)true)).orderBy(this.getImplicitOrder());
        Query query = queryBuilder.buildQuery(this.session()).setCacheMode(CacheMode.GET).setFetchSize(100);
        this.streamRepositories((Query<InternalRepository>)query, callback);
    }

    public void streamReadOnlyByHierarchy(@Nonnull String hierarchyId, @Nonnull RepositoryCallback callback) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(InternalRepository.class).where((HqlQueryBuilder.HqlWhereQueryComponent)HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"readOnly", (Object)true), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"hierarchyId", (Object)hierarchyId)})).orderBy(this.getImplicitOrder());
        Query query = queryBuilder.buildQuery(this.session()).setCacheMode(CacheMode.GET).setFetchSize(100);
        this.streamRepositories((Query<InternalRepository>)query, callback);
    }

    public InternalRepository update(InternalRepository entity) {
        return (InternalRepository)HibernateUtils.initialize((Object)((InternalRepository)super.update((Object)entity)));
    }

    public int updateOrigin(@Nonnull InternalRepository oldOrigin, InternalRepository newOrigin) {
        if (newOrigin == null) {
            return this.session().createNativeQuery("delete from sta_repo_origin where origin_id = :oldOrigin").addSynchronizedEntityClass(InternalRepository.class).setParameter("oldOrigin", (Object)oldOrigin.getId()).executeUpdate();
        }
        return this.session().createQuery("update InternalRepository set origin = :newOrigin where origin = :oldOrigin").setParameter("newOrigin", (Object)newOrigin).setParameter("oldOrigin", (Object)oldOrigin).executeUpdate();
    }

    public void updatePartitionForHierarchy(@Nonnull String hierarchyId, int partition) {
        this.session().createQuery("update InternalRepository set partition = :partition where hierarchyId = :hierarchyId").setParameter("partition", (Object)(partition < 0 ? null : Integer.valueOf(partition)), (Type)StandardBasicTypes.INTEGER).setParameter("hierarchyId", (Object)hierarchyId, (Type)StandardBasicTypes.STRING).executeUpdate();
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    private void cleanup(int repositoryId) {
        Session session = this.session();
        session.createQuery("delete from InternalWatcherMapping where watchableId in (select id from InternalCommitDiscussion where repository.id = :repoId) and watchableType = :typeId").setParameter("repoId", (Object)repositoryId, (Type)StandardBasicTypes.INTEGER).setParameter("typeId", (Object)2, (Type)StandardBasicTypes.INTEGER).executeUpdate();
        String hql = "select distinct comment.thread.id from InternalCommitDiscussionCommentActivity where repository.id = :repositoryId";
        List threadIds = session.createQuery(hql, Long.class).setParameter("repositoryId", (Object)repositoryId, (Type)StandardBasicTypes.INTEGER).list();
        this.activityDao.deleteByRepository(repositoryId);
        this.commentThreadDao.deleteByIds(threadIds);
        InternalRepository repository = (InternalRepository)session.get(InternalRepository.class, (Serializable)Integer.valueOf(repositoryId));
        InternalRepository repositoryNoOrigin = new InternalRepository.Builder(repository).origin(null).build();
        repositoryNoOrigin = (InternalRepository)this.session().merge((Object)repositoryNoOrigin);
        this.session().evict((Object)repositoryNoOrigin);
        session.flush();
    }

    private static void maybeRestrictArchivedRepository(RepositorySearchCriteria searchCriteria, HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals) {
        if (searchCriteria.hasArchived()) {
            conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"archived", (Object)searchCriteria.getArchived())});
        }
    }

    private static void maybeRestrictProjectKey(RepositorySearchCriteria searchCriteria, HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals) {
        if (searchCriteria.hasProjectKey()) {
            conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"project.key", (Object)InternalProject.keyify((String)searchCriteria.getProjectKey()))});
        }
    }

    private static void maybeRestrictProjectName(RepositorySearchCriteria searchCriteria, HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals) {
        if (searchCriteria.hasProjectName()) {
            conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"project.type", (Object)ProjectType.NORMAL), HqlQueryBuilder.HqlWhereQueryComponent.ilike((String)"project.name", (String)(searchCriteria.getProjectName() + "%"))});
        }
    }

    private static void maybeRestrictRepositoryName(RepositorySearchCriteria searchCriteria, HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals) {
        if (searchCriteria.hasName()) {
            conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.ilike((String)"name", (String)(searchCriteria.getName() + "%"))});
        }
    }

    private static void maybeRestrictState(RepositorySearchCriteria searchCriteria, HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals) {
        if (searchCriteria.hasState()) {
            conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"state", (Object)searchCriteria.getState())});
        }
    }

    private static void maybeRestrictVisibility(RepositorySearchCriteria searchCriteria, HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals) {
        if (searchCriteria.hasVisibility()) {
            HqlQueryBuilder.HqlWhereConditionalQueryComponent publiclyAccessible = HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"publiclyAccessible", (Object)true), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"project.publiclyAccessible", (Object)true)});
            switch (searchCriteria.getVisibility()) {
                case PUBLIC: {
                    conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{publiclyAccessible});
                    break;
                }
                case PRIVATE: {
                    conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.not((HqlQueryBuilder.HqlWhereQueryComponent)publiclyAccessible)});
                }
            }
        }
    }

    private boolean requiresProjectJoin(RepositorySearchCriteria searchCriteria) {
        return searchCriteria.getOrder() == RepositoryOrder.PROJECT_NAME || searchCriteria.hasVisibility() || searchCriteria.hasProjectName() || searchCriteria.hasProjectKey();
    }

    private void streamRepositories(Query<InternalRepository> query, RepositoryCallback callback) {
        try {
            callback.onStart();
            this.scrollQuery(query, new RepositoryCallbackConsumer(callback, this.session()));
        }
        finally {
            callback.onEnd();
        }
    }

    private static class RepositoryCallbackConsumer
    implements SatiableConsumer<ScrollableResults> {
        private static final int SESSION_CLEAR_INTERVAL = 1000;
        private final RepositoryCallback callback;
        private final Session session;
        private int count;

        private RepositoryCallbackConsumer(RepositoryCallback callback, Session session) {
            this.callback = callback;
            this.session = session;
        }

        public boolean accept(ScrollableResults value) {
            boolean isDone;
            boolean bl = isDone = !this.callback.onRepository((Repository)HibernateUtils.initialize((Object)((InternalRepository)value.get(0))));
            if (this.count++ == 1000) {
                this.session.clear();
                this.count = 0;
            }
            return isDone;
        }
    }
}

