/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.repository.InternalRepositoryHook;
import com.atlassian.stash.internal.repository.InternalRepositoryHook_;
import com.atlassian.stash.internal.repository.RepositoryHookDao;
import com.atlassian.stash.internal.setting.InternalSharedLob;
import jakarta.annotation.Nonnull;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryHookDao")
public class HibernateRepositoryHookDao
extends AbstractHibernateDao<Long, InternalRepositoryHook>
implements RepositoryHookDao {
    private static final int DELETE_ALL_MAX_SIZE = 1000;

    @Autowired
    public HibernateRepositoryHookDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void deleteByKey(@Nonnull Scope scope, @Nonnull String hookKey) {
        final StringBuilder queryString = new StringBuilder("delete from InternalRepositoryHook where hookKey = :hookKey and ");
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                queryString.append("( project.id = :scopeId and repository.id is null )");
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                queryString.append("( repository.id = :scopeId and project.id is null )");
                return null;
            }
        });
        this.session().createQuery(queryString.toString()).setParameter("hookKey", (Object)hookKey).setParameter("scopeId", scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Repository hooks can only be managed at project or repository scope"))).executeUpdate();
    }

    public void deleteByKeyAndRepositoryIds(@Nonnull String hookKey, @Nonnull Set<Integer> repositoryIds) {
        if (repositoryIds.isEmpty()) {
            return;
        }
        if (repositoryIds.size() > 1000) {
            throw new IllegalArgumentException("Repository ids cannot exceed 1000 entries.");
        }
        String queryString = "delete from InternalRepositoryHook where hookKey = :hookKey and project.id is null and repository.id in (:repositoryIds)";
        this.session().createQuery(queryString).setParameter("hookKey", (Object)hookKey).setParameterList("repositoryIds", repositoryIds).executeUpdate();
    }

    public InternalRepositoryHook findByKey(@Nonnull Scope scope, @Nonnull String hookKey) {
        CriteriaBuilder cb = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(InternalRepositoryHook.class);
        Root hook = criteria.from(InternalRepositoryHook.class);
        criteria.select((Selection)hook).where(new Predicate[]{this.scopePredicate(cb, (Root<InternalRepositoryHook>)hook, scope), cb.equal((Expression)hook.get(InternalRepositoryHook_.hookKey), (Object)hookKey)});
        return (InternalRepositoryHook)HibernateUtils.initialize((Object)((InternalRepositoryHook)this.session().createQuery(criteria).uniqueResult()));
    }

    @Nonnull
    public List<InternalRepositoryHook> findByKeys(@Nonnull Collection<Scope> scopes, @Nonnull Collection<String> hookKeys, boolean withSettings) {
        if (CollectionUtils.isEmpty(hookKeys)) {
            return Collections.emptyList();
        }
        CriteriaBuilder cb = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(InternalRepositoryHook.class);
        Root hook = criteria.from(InternalRepositoryHook.class);
        if (withSettings) {
            hook.fetch(InternalRepositoryHook_.settings, JoinType.LEFT);
        }
        criteria.select((Selection)hook).where(new Predicate[]{this.scopesPredicate(cb, (Root<InternalRepositoryHook>)hook, scopes), hook.get(InternalRepositoryHook_.hookKey).in(hookKeys)}).orderBy(new Order[]{cb.asc((Expression)hook.get(InternalRepositoryHook_.id))});
        return HibernateUtils.initializeList((List)this.session().createQuery(criteria).list());
    }

    public InternalRepositoryHook update(InternalRepositoryHook entity) {
        InternalSharedLob lobToDelete = null;
        if (entity.getSettings() == null && entity.getId() != 0L) {
            lobToDelete = ((InternalRepositoryHook)this.getById(Long.valueOf(entity.getId()))).getSettings();
        }
        InternalRepositoryHook updated = (InternalRepositoryHook)super.update((Object)entity);
        if (lobToDelete != null) {
            this.session().delete(lobToDelete);
        }
        return updated;
    }

    public int updateKey(@Nonnull String oldHookKey, @Nonnull String newHookKey) {
        String hql = "update InternalRepositoryHook as a set a.hookKey = :newHookKey where a.hookKey = :oldHookKey and not exists (  select 1   from InternalRepositoryHook as b   where b.hookKey = :newHookKey   and (b.project.id is null and a.project.id is null or b.project.id = a.project.id)   and (b.repository.id is null and a.repository.id is null or b.repository.id = a.repository.id))";
        Query query = this.session().createQuery(hql);
        return query.setParameter("newHookKey", (Object)newHookKey).setParameter("oldHookKey", (Object)oldHookKey).executeUpdate();
    }

    private Predicate scopePredicate(final CriteriaBuilder cb, final Root<InternalRepositoryHook> hook, Scope scope) {
        return (Predicate)scope.accept((ScopeVisitor)new ScopeVisitor<Predicate>(){

            public Predicate visit(@Nonnull GlobalScope scope) {
                throw new UnsupportedOperationException("Repository hooks cannot be managed at global scope");
            }

            public Predicate visit(@Nonnull ProjectScope scope) {
                return cb.and((Expression)cb.equal((Expression)hook.get(InternalRepositoryHook_.project), (Object)scope.getProject()), (Expression)cb.isNull((Expression)hook.get(InternalRepositoryHook_.repository)));
            }

            public Predicate visit(@Nonnull RepositoryScope scope) {
                return cb.and((Expression)cb.equal((Expression)hook.get(InternalRepositoryHook_.repository), (Object)scope.getRepository()), (Expression)cb.isNull((Expression)hook.get(InternalRepositoryHook_.project)));
            }
        });
    }

    private Predicate scopesPredicate(CriteriaBuilder cb, Root<InternalRepositoryHook> hook, Collection<Scope> scopes) {
        return cb.or((Predicate[])scopes.stream().map(scope -> this.scopePredicate(cb, hook, (Scope)scope)).toArray(Predicate[]::new));
    }
}

