/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositorySize;
import com.atlassian.stash.internal.repository.RepositorySizeDao;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositorySizeDao")
public class HibernateRepositorySizeDao
extends AbstractHibernateDao<Integer, InternalRepositorySize>
implements RepositorySizeDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"repositoryId"));

    @Autowired
    public HibernateRepositorySizeDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Page<InternalRepository> findRepositoriesWithoutSize(int afterId, @Nonnull PageRequest pageRequest) {
        String hql = "SELECT r FROM InternalRepository r LEFT JOIN InternalRepositorySize rs ON r.id=rs.id WHERE r.id > :afterId AND rs.id IS NULL ORDER BY r.id";
        Query query = this.session().createQuery(hql, InternalRepository.class).setParameter("afterId", (Object)afterId);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

