/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling;

import com.atlassian.scheduler.caesium.spi.ClusteredJob;
import com.atlassian.scheduler.caesium.spi.ClusteredJobDao;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.stash.internal.scheduling.InternalClusteredJob;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Repository(value="clusteredJobDao")
public class HibernateClusteredJobDao
implements ClusteredJobDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateClusteredJobDao.class);
    private final SessionFactory sessionFactory;
    private final TransactionTemplate readOnlyTransaction;
    private final TransactionTemplate readWriteTransaction;

    @Autowired
    public HibernateClusteredJobDao(SessionFactory sessionFactory, PlatformTransactionManager transactionManager) {
        this.sessionFactory = sessionFactory;
        this.readOnlyTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.readOnlyTransaction.setReadOnly(true);
        this.readWriteTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    public boolean create(@Nonnull ClusteredJob clusteredJob) {
        try {
            return (Boolean)this.readWriteTransaction.execute(action -> {
                this.session().save((Object)new InternalClusteredJob.Builder(clusteredJob).build());
                return true;
            });
        }
        catch (NonUniqueObjectException | DataIntegrityViolationException e) {
            return false;
        }
    }

    public boolean delete(@Nonnull JobId jobId) {
        int rows = (Integer)this.readWriteTransaction.execute(action -> this.session().createQuery("delete from InternalClusteredJob where jobId = :jobId").setParameter("jobId", (Object)jobId.toString()).executeUpdate());
        return rows > 0;
    }

    @Nullable
    public ClusteredJob find(@Nonnull JobId jobId) {
        return (ClusteredJob)this.readOnlyTransaction.execute(status -> (InternalClusteredJob)this.session().get(InternalClusteredJob.class, (Serializable)((Object)jobId.toString())));
    }

    @Nonnull
    public Set<JobRunnerKey> findAllJobRunnerKeys() {
        List results = (List)this.readOnlyTransaction.execute(status -> this.session().createQuery("select distinct jobRunnerKey from InternalClusteredJob").list());
        ImmutableSet.Builder keys = ImmutableSet.builder();
        for (Object result : results) {
            keys.add((Object)JobRunnerKey.of((String)((String)result)));
        }
        return keys.build();
    }

    @Nonnull
    public Collection<ClusteredJob> findByJobRunnerKey(@Nonnull JobRunnerKey jobRunnerKey) {
        List results = (List)this.readOnlyTransaction.execute(status -> this.session().createQuery("from InternalClusteredJob where jobRunnerKey = :jobRunnerKey").setParameter("jobRunnerKey", (Object)jobRunnerKey.toString()).list());
        ImmutableSet.Builder clusteredJobs = ImmutableSet.builder();
        for (Object result : results) {
            clusteredJobs.add((Object)((InternalClusteredJob)result));
        }
        return clusteredJobs.build();
    }

    @Nullable
    public Date getNextRunTime(@Nonnull JobId jobId) {
        Object result = this.readOnlyTransaction.execute(status -> this.session().createQuery("select nextRun from InternalClusteredJob where jobId = :jobId").setParameter("jobId", (Object)jobId.toString()).uniqueResult());
        return result == null ? null : new Date(((Timestamp)result).getTime());
    }

    @Nullable
    public Long getVersion(@Nonnull JobId jobId) {
        return (Long)this.readOnlyTransaction.execute(status -> this.session().createQuery("select version from InternalClusteredJob where jobId = :jobId").setParameter("jobId", (Object)jobId.toString()).uniqueResult());
    }

    @Nonnull
    public Map<JobId, Date> refresh() {
        List results = (List)this.readOnlyTransaction.execute(status -> this.session().createQuery("select jobId, nextRun from InternalClusteredJob where nextRun is not null").list());
        ImmutableMap.Builder jobMap = ImmutableMap.builder();
        for (Object result : results) {
            Object[] columns = (Object[])result;
            jobMap.put((Object)JobId.of((String)((String)columns[0])), (Object)((Date)columns[1]));
        }
        return jobMap.build();
    }

    public boolean updateNextRunTime(@Nonnull JobId jobId, @Nullable Date date, long version) {
        int rows = (Integer)this.readWriteTransaction.execute(status -> this.session().createQuery("update InternalClusteredJob set nextRun = :nextRun, version = :newVersion where jobId = :jobId and version = :version").setParameter("nextRun", (Object)date).setParameter("newVersion", (Object)(version + 1L)).setParameter("jobId", (Object)jobId.toString()).setParameter("version", (Object)version).executeUpdate());
        return rows > 0;
    }

    private Session session() {
        return this.sessionFactory.getCurrentSession();
    }
}

