/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCachedAncestorDao;
import com.atlassian.stash.internal.scm.git.pull.InternalGitPullRequestCachedAncestor;
import jakarta.annotation.Nonnull;
import org.hibernate.SessionFactory;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.stereotype.Repository;

@Repository(value="gitPullRequestCachedAncestorDao")
public class HibernateGitPullRequestCachedAncestorDao
extends AbstractHibernateDao<Long, InternalGitPullRequestCachedAncestor>
implements GitPullRequestCachedAncestorDao {
    public HibernateGitPullRequestCachedAncestorDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public InternalGitPullRequestCachedAncestor findByPullRequest(@Nonnull PullRequest pullRequest) {
        return (InternalGitPullRequestCachedAncestor)this.getById(Long.valueOf(((InternalPullRequest)pullRequest).getGlobalId()));
    }

    public InternalGitPullRequestCachedAncestor findByPullRequestIfCurrent(@Nonnull PullRequest pullRequest) {
        String hql = "from InternalGitPullRequestCachedAncestor where id = :id and fromHash = :fromHash and toHash = :toHash";
        return (InternalGitPullRequestCachedAncestor)this.session().createQuery(hql, InternalGitPullRequestCachedAncestor.class).setParameter("id", (Object)((InternalPullRequest)pullRequest).getGlobalId(), (Type)StandardBasicTypes.LONG).setParameter("fromHash", (Object)pullRequest.getFromRef().getLatestCommit(), (Type)StandardBasicTypes.STRING).setParameter("toHash", (Object)pullRequest.getToRef().getLatestCommit(), (Type)StandardBasicTypes.STRING).uniqueResult();
    }
}

