/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCachedMergeDao;
import com.atlassian.stash.internal.scm.git.pull.InternalGitPullRequestCachedMerge;
import jakarta.annotation.Nonnull;
import org.hibernate.SessionFactory;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.stereotype.Repository;

@Repository(value="gitPullRequestCachedMergeDao")
public class HibernateGitPullRequestCachedMergeDao
extends AbstractHibernateDao<Long, InternalGitPullRequestCachedMerge>
implements GitPullRequestCachedMergeDao {
    public HibernateGitPullRequestCachedMergeDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public InternalGitPullRequestCachedMerge findByPullRequest(@Nonnull PullRequest pullRequest) {
        return (InternalGitPullRequestCachedMerge)this.getById(Long.valueOf(((InternalPullRequest)pullRequest).getGlobalId()));
    }

    public InternalGitPullRequestCachedMerge findByPullRequestIfCurrent(@Nonnull PullRequest pullRequest) {
        String hql = "from InternalGitPullRequestCachedMerge where id = :id and fromHash = :fromHash and toHash = :toHash";
        return (InternalGitPullRequestCachedMerge)this.session().createQuery(hql, InternalGitPullRequestCachedMerge.class).setParameter("id", (Object)((InternalPullRequest)pullRequest).getGlobalId(), (Type)StandardBasicTypes.LONG).setParameter("fromHash", (Object)pullRequest.getFromRef().getLatestCommit(), (Type)StandardBasicTypes.STRING).setParameter("toHash", (Object)pullRequest.getToRef().getLatestCommit(), (Type)StandardBasicTypes.STRING).uniqueResult();
    }
}

