/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.secrets;

import com.atlassian.bitbucket.dmz.secrets.LazySecretDao;
import com.atlassian.bitbucket.dmz.secrets.SecretNamespace;
import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.secrets.InternalSealedSecret;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.SessionFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="hibernateSecretDao")
@Transactional
public class HibernateSecretDao
extends AbstractHibernateDao<String, InternalSealedSecret>
implements LazySecretDao {
    public HibernateSecretDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void delete(@Nonnull String identifier) throws SecretServiceException {
        this.deleteById((Serializable)((Object)Objects.requireNonNull(identifier, "identifier")));
    }

    @Transactional(readOnly=true)
    public Optional<SealedSecret> get(@Nonnull String identifier) throws SecretServiceException {
        Objects.requireNonNull(identifier, "identifier");
        InternalSealedSecret internalSealedSecret = (InternalSealedSecret)this.getById((Serializable)((Object)identifier));
        if (internalSealedSecret == null) {
            return Optional.empty();
        }
        return Optional.of(internalSealedSecret.toSealedSecret());
    }

    @Transactional(readOnly=true)
    public Set<String> getIdsForBackend(@Nonnull String backendId) throws SecretServiceException {
        Objects.requireNonNull(backendId, "backendId");
        String hql = "select ss.identifier from InternalSealedSecret ss where backendId = :backendId";
        return ImmutableSet.copyOf((Collection)this.session().createQuery(hql, String.class).setParameter("backendId", (Object)backendId).getResultList());
    }

    public void put(@Nonnull Set<SealedSecret> sealedSecrets) throws SecretServiceException {
        Objects.requireNonNull(sealedSecrets, "sealedSecrets");
        this.validateEnvironmentSecrets(sealedSecrets);
        for (SealedSecret sealedSecret : sealedSecrets) {
            this.update(new InternalSealedSecret.Builder(sealedSecret).build());
        }
    }

    private boolean isEnvironmentNamespaced(SealedSecret sealedSecret) {
        return SecretNamespace.fromIdentifier((String)sealedSecret.getIdentifier()).map(arg_0 -> SecretNamespace.ENVIRONMENT.equals(arg_0)).orElse(false);
    }

    private boolean secretExists(String identifier) throws SecretServiceException {
        return this.getById((Serializable)((Object)identifier)) != null;
    }

    private void validateEnvironmentSecrets(Set<SealedSecret> sealedSecrets) {
        Set invalidSecrets = sealedSecrets.stream().filter(this::isEnvironmentNamespaced).map(SealedSecret::getIdentifier).collect(Collectors.toUnmodifiableSet());
        if (!invalidSecrets.isEmpty()) {
            throw new SecretServiceException(String.format("Environment secrets detected %s and are not allowed in the database", invalidSecrets));
        }
    }
}

