/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.server.DataStoreDao;
import com.atlassian.stash.internal.server.InternalDataStore;
import jakarta.annotation.Nonnull;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="dataHomeDao")
public class HibernateDataStoreDao
extends AbstractHibernateDao<Long, InternalDataStore>
implements DataStoreDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"path"));

    @Autowired
    public HibernateDataStoreDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long countAll() {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        criteria.select((Selection)builder.count((Expression)criteria.from(InternalDataStore.class)));
        return (Long)this.session().createQuery(criteria).uniqueResult();
    }

    public void delete(InternalDataStore shard) {
        throw new UnsupportedOperationException(InternalDataStore.class.getSimpleName() + "s cannot be deleted");
    }

    public void deleteById(Long id) {
        throw new UnsupportedOperationException(InternalDataStore.class.getSimpleName() + "s cannot be deleted");
    }

    @Nonnull
    public Optional<InternalDataStore> findByPath(@Nonnull String path) {
        return this.session().createQuery("from InternalDataStore where path = :path", InternalDataStore.class).setParameter("path", (Object)path).uniqueResultOptional();
    }

    @Nonnull
    public List<InternalDataStore> listAll() {
        return this.session().createQuery("from InternalDataStore order by id", InternalDataStore.class).list();
    }

    public InternalDataStore update(InternalDataStore shard) {
        throw new UnsupportedOperationException(InternalDataStore.class.getSimpleName() + "s are immutable and may not be updated");
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

