/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.dmz.server.MinimalDataStore;
import com.atlassian.stash.internal.server.MinimalDataStoreDao;
import com.atlassian.stash.internal.server.SimpleMinimalDataStore;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@DependsOn(value={"bootstrapLiquibase"})
@Repository(value="minimalDataStoreDao")
public class JdbcMinimalDataStoreDao
implements MinimalDataStoreDao {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    @Autowired
    public JdbcMinimalDataStoreDao(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Nonnull
    public List<MinimalDataStore> listAll() {
        return this.jdbcTemplate.query("SELECT id, ds_path, ds_uuid FROM bb_data_store ORDER BY id", (rs, rowNum) -> new SimpleMinimalDataStore(rs.getLong(1), rs.getString(2), rs.getString(3)));
    }
}

