/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction;

import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionOrder;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionSearchRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.settingsrestriction.InternalProjectSettingsRestriction;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionDao;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="projectSettingsRestrictionDao")
public class HibernateProjectSettingsRestrictionDao
extends AbstractHibernateDao<Long, InternalProjectSettingsRestriction>
implements ProjectSettingsRestrictionDao {
    private static final int PARTITION_SIZE = 300;
    private static final Logger log = LoggerFactory.getLogger(HibernateProjectSettingsRestrictionDao.class);

    public HibernateProjectSettingsRestrictionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public boolean deleteByProjectAndSettingsKey(@Nonnull Project project, @Nonnull SettingsKey settingsKey) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(settingsKey, "settingsKey");
        String hql = "delete from InternalProjectSettingsRestriction where namespace = :namespace and featureKey = :featureKey and componentKey = :componentKey and project.id = :projectId and processedState in (:finishedStates)";
        int deletedRows = this.session().createQuery(hql).setParameter("namespace", (Object)settingsKey.getNamespace()).setParameter("featureKey", (Object)settingsKey.getFeatureKey()).setParameter("componentKey", (Object)settingsKey.getComponentKey().orElse("#")).setParameter("projectId", (Object)project.getId()).setParameterList("finishedStates", (Collection)RestrictionProcessedState.getFinishedStates()).executeUpdate();
        if (deletedRows > 1) {
            log.warn("Multiple restrictions for settings key {} found in project {}", (Object)settingsKey, (Object)project.getName());
        }
        return deletedRows > 0;
    }

    @Nonnull
    public Collection<InternalProjectSettingsRestriction> getAllByProject(@Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        String hql = "from InternalProjectSettingsRestriction where project = :project";
        List results = this.session().createQuery(hql, InternalProjectSettingsRestriction.class).setParameter("project", (Object)project).getResultList();
        return HibernateUtils.initializeList((List)results);
    }

    @Nonnull
    public List<InternalProjectSettingsRestriction> getByIds(@Nonnull Collection<Long> ids) {
        return HibernateUtils.initializeList((List)super.getByIds(Objects.requireNonNull(ids, "ids")));
    }

    @Nonnull
    public Optional<InternalProjectSettingsRestriction> getByProjectAndSettingsKey(@Nonnull Project project, @Nonnull SettingsKey settingsKey) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(settingsKey, "settingsKey");
        String hql = "from InternalProjectSettingsRestriction where namespace = :namespace and featureKey = :featureKey and componentKey = :componentKey and project.id = :projectId";
        return this.session().createQuery(hql, InternalProjectSettingsRestriction.class).setParameter("namespace", (Object)settingsKey.getNamespace()).setParameter("featureKey", (Object)settingsKey.getFeatureKey()).setParameter("componentKey", (Object)settingsKey.getComponentKey().orElse("#")).setParameter("projectId", (Object)project.getId()).setMaxResults(1).uniqueResultOptional().map(HibernateUtils::initialize);
    }

    @Nonnull
    public Set<InternalProjectSettingsRestriction> getAllByProjectNamespaceAndFeatureKey(@Nonnull Project project, @Nonnull String namespace, @Nonnull String featureKey) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(namespace, "namespace");
        Objects.requireNonNull(featureKey, "featureKey");
        String hql = "from InternalProjectSettingsRestriction where project.id = :projectId and namespace = :namespace and featureKey = :featureKey";
        List results = this.session().createQuery(hql, InternalProjectSettingsRestriction.class).setParameter("projectId", (Object)project.getId()).setParameter("namespace", (Object)namespace).setParameter("featureKey", (Object)featureKey).getResultList();
        return ImmutableSet.copyOf((Collection)HibernateUtils.initializeList((List)results));
    }

    @Nonnull
    public Set<Integer> getRestrictedProjects(@Nonnull Collection<Integer> projectIds, @Nonnull SettingsKey settingsKey) {
        Objects.requireNonNull(projectIds, "projects");
        Objects.requireNonNull(settingsKey, "settingsKey");
        String hql = "select project.id from InternalProjectSettingsRestriction where project.id in (:projectIds) and namespace = :namespace and featureKey = :featureKey and componentKey = :componentKey";
        return (Set)MoreStreams.streamIterable((Iterable)Iterables.partition(projectIds, (int)300)).map(ids -> this.createProjectIdQuery((Collection<Integer>)ids, hql, settingsKey).getResultList()).flatMap(Collection::stream).collect(MoreCollectors.toImmutableSet());
    }

    public boolean hasRestrictions(@Nonnull Collection<Integer> projectIds, @Nonnull SettingsKey settingsKey) {
        Objects.requireNonNull(projectIds, "projects");
        Objects.requireNonNull(settingsKey, "settingsKey");
        if (projectIds.isEmpty()) {
            return false;
        }
        String hql = "select 1 from InternalProjectSettingsRestriction where project.id in (:projectIds) and namespace = :namespace and featureKey = :featureKey and componentKey = :componentKey";
        return MoreStreams.streamIterable((Iterable)Iterables.partition(projectIds, (int)300)).map(ids -> (Integer)this.createProjectIdQuery((Collection<Integer>)ids, hql, settingsKey).setMaxResults(1).uniqueResult()).anyMatch(Objects::nonNull);
    }

    public int resetExpiredInProgress(@Nonnull Instant processingStartedOnOrBefore) {
        Objects.requireNonNull(processingStartedOnOrBefore, "processingStartedOnOrBefore");
        String hql = "update InternalProjectSettingsRestriction set processedState = :newProcessedState where processedState = :oldProcessedState and processingStartedTimestamp is not null and processingStartedTimestamp <= :processingStartedOnOrBefore";
        return this.session().createQuery(hql).setParameter("newProcessedState", (Object)RestrictionProcessedState.UNPROCESSED).setParameter("oldProcessedState", (Object)RestrictionProcessedState.IN_PROGRESS).setParameter("processingStartedOnOrBefore", (Object)processingStartedOnOrBefore).executeUpdate();
    }

    @Nonnull
    public Page<InternalProjectSettingsRestriction> search(@Nonnull ProjectSettingsRestrictionSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(searchRequest, "searchRequest");
        Objects.requireNonNull(pageRequest, "pageRequest");
        String hql = "from InternalProjectSettingsRestriction where processedState = :processedState order by " + this.resolveOrderClause(searchRequest.getOrder());
        Query query = this.session().createQuery(hql, InternalProjectSettingsRestriction.class).setParameter("processedState", (Object)searchRequest.getProcessedState());
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    public boolean setProcessedState(@Nonnull Project project, @Nonnull SettingsKey settingsKey, @Nonnull RestrictionProcessedState newProcessedState) {
        Objects.requireNonNull(project, "projects");
        Objects.requireNonNull(settingsKey, "settingsKey");
        Objects.requireNonNull(newProcessedState, "newProcessedState");
        Object hql = "update InternalProjectSettingsRestriction set processedState = :newProcessedState ";
        hql = newProcessedState == RestrictionProcessedState.IN_PROGRESS ? (String)hql + ", processingStartedTimestamp = current_timestamp " : (String)hql + ", processingAttempts = (processingAttempts + 1) ";
        hql = (String)hql + "where namespace = :namespace and featureKey = :featureKey and componentKey = :componentKey and project.id = :projectId";
        int updatedRows = this.session().createQuery((String)hql).setParameter("newProcessedState", (Object)newProcessedState).setParameter("namespace", (Object)settingsKey.getNamespace()).setParameter("featureKey", (Object)settingsKey.getFeatureKey()).setParameter("componentKey", (Object)settingsKey.getComponentKey().orElse("#")).setParameter("projectId", (Object)project.getId()).executeUpdate();
        if (updatedRows > 1) {
            log.warn("Multiple restrictions for settings key {} found in project {}", (Object)settingsKey, (Object)project.getName());
        }
        return updatedRows > 0;
    }

    public InternalProjectSettingsRestriction update(InternalProjectSettingsRestriction entity) {
        throw new UnsupportedOperationException("ProjectSettingsRestrictions are immutable and cannot be updated");
    }

    private Query<Integer> createProjectIdQuery(Collection<Integer> ids, String hql, SettingsKey settingsKey) {
        return this.session().createQuery(hql, Integer.class).setParameterList("projectIds", ids).setParameter("namespace", (Object)settingsKey.getNamespace()).setParameter("featureKey", (Object)settingsKey.getFeatureKey()).setParameter("componentKey", (Object)settingsKey.getComponentKey().orElse("#"));
    }

    private String resolveOrderClause(ProjectSettingsRestrictionOrder order) {
        switch (order) {
            case PROCESSING_ATTEMPTS_ASC_AND_ID_ASC: {
                return "processingAttempts asc, id asc ";
            }
        }
        return "id asc ";
    }
}

