/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.upgrade;

import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.atlassian.stash.internal.liquibase.database.ExtendedSpringLiquibase;
import com.atlassian.stash.internal.upgrade.AsyncMigrationDao;
import com.atlassian.stash.internal.upgrade.SimpleAsyncMigrationStatus;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.sql.Connection;
import javax.sql.DataSource;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.AbstractChangeExecListener;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.StandardLockService;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class LiquibaseAsyncMigrationDao
implements AsyncMigrationDao,
ResourceLoaderAware {
    public static final String LOCK_TABLE_NAME = "asyncdblock";
    private static final Logger log = LoggerFactory.getLogger(LiquibaseAsyncMigrationDao.class);
    private final DataSource dataSource;
    private ResourceLoader resourceLoader;

    @Autowired
    public LiquibaseAsyncMigrationDao(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public SimpleAsyncMigrationStatus getStatus() {
        Database database = null;
        try {
            database = LiquibaseUtils.findDatabase((DataSource)this.dataSource);
            database.setDatabaseChangeLogLockTableName(LOCK_TABLE_NAME);
            StandardLockService lockService = new StandardLockService();
            lockService.setDatabase(database);
            DatabaseChangeLogLock[] locks = lockService.listLocks();
            if (locks.length > 0) {
                SimpleAsyncMigrationStatus simpleAsyncMigrationStatus = new SimpleAsyncMigrationStatus(true, locks[0].getLockedBy(), locks[0].getLockGranted());
                return simpleAsyncMigrationStatus;
            }
        }
        catch (Exception e) {
            log.warn("Exception trying to determine if the async db migration is locked", (Throwable)e);
        }
        finally {
            try {
                if (database != null) {
                    database.close();
                }
            }
            catch (DatabaseException de) {
                log.error("Failed to close database", (Throwable)de);
            }
        }
        return new SimpleAsyncMigrationStatus(false, null, null);
    }

    public void setResourceLoader(@Nonnull ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void upgrade() {
        AsyncMigrationChangeExecListener listener = new AsyncMigrationChangeExecListener();
        ExtendedSpringLiquibase liquibase = this.createLiquibase();
        liquibase.setChangeExecListener((ChangeExecListener)listener);
        try {
            liquibase.afterPropertiesSet();
            if (listener.hasRun) {
                log.info("Async upgrade completed");
            }
        }
        catch (LiquibaseException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    ExtendedSpringLiquibase createLiquibase() {
        ExtendedSpringLiquibase liquibase = new ExtendedSpringLiquibase(this, this.dataSource){

            @Override
            protected Database createDatabase(Connection connection, ResourceAccessor accessor) throws DatabaseException {
                Database database = super.createDatabase(connection, accessor);
                database.setDatabaseChangeLogLockTableName(LiquibaseAsyncMigrationDao.LOCK_TABLE_NAME);
                return database;
            }
        };
        liquibase.setBeanName("asyncLiquibase");
        liquibase.setChangeLog("classpath:liquibase/masterAsync.xml");
        liquibase.setResourceLoader(this.resourceLoader);
        return liquibase;
    }

    private static class AsyncMigrationChangeExecListener
    extends AbstractChangeExecListener {
        private boolean hasRun;

        private AsyncMigrationChangeExecListener() {
        }

        public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
            if (!this.hasRun) {
                log.info("Starting async db upgrade. This can be a slow operation (no further logging will happen until upgrade is done), the system should be responsive and handle requests while this is in progress");
                this.hasRun = true;
            }
        }
    }
}

