/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.PermittedGroup;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalApplicationUser_;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalPermissionType;
import com.atlassian.stash.internal.user.InternalPermissionType_;
import com.atlassian.stash.internal.user.InternalPermittedGroup;
import com.atlassian.stash.internal.user.InternalPermittedUser;
import com.atlassian.stash.internal.user.InternalScopedPermission;
import com.atlassian.stash.internal.user.InternalScopedPermission_;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.PermissionDao;
import jakarta.annotation.Nonnull;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public abstract class AbstractHibernatePermissionDao<E extends InternalScopedPermission>
extends AbstractHibernateDao<Long, E>
implements PermissionDao<E> {
    public static final String FIELD_DISPLAY_NAME = "displayName";
    public static final String FIELD_USERNAME = "username";

    public AbstractHibernatePermissionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long countPermissionsForAllGroups() {
        String hql = "select count(*) from " + this.entityClass.getSimpleName() + " perm  where perm.user is null and perm.group is not null";
        return (Long)this.session().createQuery(hql, Long.class).uniqueResult();
    }

    public long countPermissionsForAllUsers() {
        String hql = "select count(*) from " + this.entityClass.getSimpleName() + " perm  where perm.group is null and perm.user is not null";
        return (Long)this.session().createQuery(hql, Long.class).uniqueResult();
    }

    public boolean hasPermissionEntry(@Nonnull E permission) {
        Query query = HqlQueryBuilder.selectPropertiesFrom(permission.getClass(), (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.rowCount()}).where(this.createHasPermissionConditions(permission)).buildQuery(this.session(), Long.class);
        return (Long)query.uniqueResult() > 0L;
    }

    public int revokeAll(int userId) {
        return this.session().createQuery("delete " + this.entityClass.getSimpleName() + " p where p.user.id = :userId").setParameter("userId", (Object)userId, (Type)StandardBasicTypes.INTEGER).executeUpdate();
    }

    public int revokeAll(@Nonnull String groupName) {
        return this.session().createQuery("delete " + this.entityClass.getSimpleName() + " p where p.group = :groupName").setParameter("groupName", (Object)IdentifierUtils.toLowerCase((String)groupName)).executeUpdate();
    }

    protected Query<PermittedGroup> createFindHighestPermissionPerGroupQuery(String filter, BiFunction<CriteriaBuilder, Root<E>, Predicate> additionalClause) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PermittedGroup.class);
        Root permissionRoot = criteria.from(this.entityClass);
        Root typeRoot = criteria.from(InternalPermissionType.class);
        Path group = permissionRoot.get(InternalScopedPermission_.group);
        Expression maxWeight = builder.max((Expression)typeRoot.get(InternalPermissionType_.weight));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(4);
        predicates.add(builder.equal((Expression)permissionRoot.get(InternalScopedPermission_.permission), (Expression)typeRoot.get(InternalPermissionType_.id)));
        predicates.add(builder.isNull((Expression)permissionRoot.get(InternalScopedPermission_.user)));
        predicates.add(StringUtils.isEmpty((CharSequence)filter) ? builder.isNotNull((Expression)group) : builder.like((Expression)group, "%" + IdentifierUtils.toLowerCase((String)filter) + "%"));
        if (additionalClause != null) {
            predicates.add(additionalClause.apply(builder, permissionRoot));
        }
        criteria.select((Selection)builder.construct(InternalPermittedGroup.class, new Selection[]{group, maxWeight})).where(predicates.toArray(new Predicate[0])).groupBy(new Expression[]{group}).orderBy(new Order[]{builder.asc((Expression)group)});
        return this.session().createQuery(criteria);
    }

    protected Query<Object[]> createFindHighestPermissionPerUserQuery(Page<ApplicationUser> users, BiFunction<CriteriaBuilder, Root<E>, Predicate> additionalClause) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Object[].class);
        Root permissionRoot = criteria.from(this.entityClass);
        Root typeRoot = criteria.from(InternalPermissionType.class);
        Path userId = permissionRoot.get(InternalScopedPermission_.user).get(InternalApplicationUser_.id);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(3);
        predicates.add(builder.equal((Expression)permissionRoot.get(InternalScopedPermission_.permission), (Expression)typeRoot.get(InternalPermissionType_.id)));
        predicates.add(userId.in((Collection)users.stream().map(ApplicationUser::getId).collect(Collectors.toList())));
        if (additionalClause != null) {
            predicates.add(additionalClause.apply(builder, permissionRoot));
        }
        criteria.multiselect(new Selection[]{userId, builder.max((Expression)typeRoot.get(InternalPermissionType_.weight))}).where(predicates.toArray(new Predicate[0])).groupBy(new Expression[]{userId});
        return this.session().createQuery(criteria);
    }

    protected HqlQueryBuilder.HqlWhereQueryComponent createHasPermissionConditions(E permission) {
        return HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"permission", (Object)permission.getPermission()), permission.getGroup() == null ? HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"group") : HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"group", (Object)IdentifierUtils.toLowerCase((String)permission.getGroup())), permission.getUser() == null ? HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"user") : HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"user", (Object)permission.getUser())});
    }

    protected Query<?> createRevokeQuery(InternalScopedPermission permission, String additionalClause) {
        Query query = this.session().createQuery("delete " + this.entityClass.getSimpleName() + " perm where perm.permission = :permission and " + (permission.getUser() == null ? "perm.user is null " : "perm.user = :user ") + "and " + (permission.getGroup() == null ? "perm.group is null " : "perm.group = :groupName ") + (String)(additionalClause != null ? "and perm." + additionalClause : "")).setParameter("permission", (Object)permission.getPermission());
        if (permission.getUser() != null) {
            query.setParameter("user", (Object)permission.getUser());
        }
        if (permission.getGroup() != null) {
            query.setParameter("groupName", (Object)IdentifierUtils.toLowerCase((String)permission.getGroup()));
        }
        return query;
    }

    protected Page<String> findGroupsWithPermission(PageRequest pageRequest, Class<? extends InternalScopedPermission> selectClass, HqlQueryBuilder.HqlWhereQueryComponent additionalWhereClause) {
        HqlQueryBuilder.HqlWhereConditionalQueryComponent whereQueryComponent = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"user"), HqlQueryBuilder.HqlWhereQueryComponent.isNotNull((String)"group")});
        if (additionalWhereClause != null) {
            whereQueryComponent.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{additionalWhereClause});
        }
        Query query = HqlQueryBuilder.selectDistinctPropertiesFrom(selectClass, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"group")}).where((HqlQueryBuilder.HqlWhereQueryComponent)whereQueryComponent).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"group")}).buildQuery(this.session(), String.class).setCacheable(true).setCacheRegion("query.permissions");
        return this.pageQuery(query, pageRequest);
    }

    protected Page<ApplicationUser> findUsersWithPermission(UserType userType, String filter, PageRequest pageRequest, Class<? extends InternalScopedPermission> selectClass, HqlQueryBuilder.HqlWhereQueryComponent additionalWhereClause) {
        HqlQueryBuilder.HqlQueryOrder userOrderClauses;
        HqlQueryBuilder.HqlWhereConditionalQueryComponent permissionWhereClauses = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNotNull((String)"user"), HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"group")});
        if (additionalWhereClause != null) {
            permissionWhereClauses.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{additionalWhereClause});
        }
        HqlQueryBuilder permissionQueryBuilder = HqlQueryBuilder.selectDistinctPropertiesFrom(selectClass, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"user.id")}).where((HqlQueryBuilder.HqlWhereQueryComponent)permissionWhereClauses);
        HqlQueryBuilder.HqlWhereConditionalQueryComponent userWhereClauses = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.inSubQuery((String)"id", (HqlQueryBuilder)permissionQueryBuilder)});
        if (userType == UserType.NORMAL) {
            userOrderClauses = HqlQueryBuilder.HqlQueryOrder.asc((String)FIELD_USERNAME);
            if (StringUtils.isNotEmpty((CharSequence)filter)) {
                userWhereClauses.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.ilike((String)FIELD_USERNAME, (String)("%" + filter + "%"))});
            }
        } else {
            userOrderClauses = HqlQueryBuilder.HqlQueryOrder.asc((String)FIELD_DISPLAY_NAME);
            if (StringUtils.isNotEmpty((CharSequence)filter)) {
                userWhereClauses.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.ilike((String)FIELD_DISPLAY_NAME, (String)("%" + filter + "%"))});
            }
        }
        Query userQuery = HqlQueryBuilder.selectFrom(AbstractHibernatePermissionDao.userEntityForType(userType)).where((HqlQueryBuilder.HqlWhereQueryComponent)userWhereClauses).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{userOrderClauses}).buildQuery(this.session(), ApplicationUser.class);
        return this.pageQuery(userQuery, pageRequest);
    }

    protected Page<PermittedUser> pairUsersWithPermissions(Page<ApplicationUser> page, Query<Object[]> query) {
        List values = query.list();
        HashMap<Integer, Integer> idToWeight = new HashMap<Integer, Integer>(values.size());
        for (Object[] objects : values) {
            idToWeight.put((Integer)objects[0], (Integer)objects[1]);
        }
        return page.transform(user -> {
            Integer weight = (Integer)idToWeight.get(user.getId());
            if (weight == null) {
                throw new IllegalStateException("No weight was found for the permission assigned to " + user.getName());
            }
            return new InternalPermittedUser(user, weight.intValue());
        });
    }

    private static Class<? extends InternalApplicationUser> userEntityForType(UserType userType) {
        switch (userType) {
            case NORMAL: {
                return InternalNormalUser.class;
            }
            case SERVICE: {
                return InternalServiceUser.class;
            }
        }
        throw new IllegalArgumentException("Unexpected user type " + String.valueOf(userType));
    }
}

