/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.InternalUserSettings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="stashUserDao")
public class HibernateApplicationUserDao
extends AbstractHibernateDao<Integer, InternalApplicationUser>
implements ApplicationUserDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateApplicationUserDao.class);
    private static final String FIELD_ACTIVE = "active";
    private static final String FIELD_DELETED_DATE = "deletedDate";
    private static final String FIELD_DISPLAY_NAME = "displayName";
    private static final String FIELD_SLUG = "slug";
    private static final String FIELD_USERNAME = "username";
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"username"));
    private static final int MAX_USERNAME_LENGTH = 255;
    private final SecureTokenGenerator tokenGenerator;
    private final String initialUserSettings;

    @Autowired
    public HibernateApplicationUserDao(BuildInfo buildInfo, SessionFactory sessionFactory, SecureTokenGenerator tokenGenerator) {
        super(sessionFactory);
        this.tokenGenerator = tokenGenerator;
        this.initialUserSettings = String.format("{\"%s\":\"%s\",\"%s\":true}", "user.created.version", new Version(buildInfo.getBuildVersion()), "SHOW_GETTING_STARTED_PAGE");
    }

    @Nonnull
    public InternalNormalUser archive(@Nonnull InternalNormalUser user) {
        String archivedSlug;
        Objects.requireNonNull(user, "user");
        int counter = 0;
        Object suffix = "_ar";
        String archivedName = this.safeAppendSuffix(user.getName(), 255, (String)suffix);
        while (this.findByName(archivedName) != null && ++counter < 100) {
            suffix = "_ar" + counter;
            archivedName = this.safeAppendSuffix(user.getName(), 255, (String)suffix);
        }
        if (counter == 100) {
            archivedName = this.tokenGenerator.generateToken();
            while (this.findByName(archivedName) != null) {
                archivedName = this.tokenGenerator.generateToken();
            }
            archivedSlug = this.generateUniqueSlugForUser(archivedName, user.getType(), (InternalApplicationUser)user);
        } else {
            archivedSlug = this.generateUniqueSlugForUser(this.safeAppendSuffix(user.getName(), 126, (String)suffix), user.getType(), (InternalApplicationUser)user);
        }
        log.info("Archiving user {} with slug {} to {}/{}", new Object[]{user.getName(), user.getSlug(), archivedName, archivedSlug});
        return (InternalNormalUser)this.update(((InternalNormalUser.Builder)((InternalNormalUser.Builder)user.copy().name(archivedName)).slug(archivedSlug)).build());
    }

    @Nonnull
    public InternalNormalUser create(@Nonnull InternalNormalUser user) {
        String slug = this.generateUniqueSlug(user.getName(), UserType.NORMAL);
        return (InternalNormalUser)((InternalApplicationUser)super.create((Object)((InternalNormalUser.Builder)user.copy().slug(slug)).build())).accept((InternalStashUserVisitor)InternalNormalUser.TO_NORMAL_USER);
    }

    @Nonnull
    public InternalServiceUser create(@Nonnull InternalServiceUser user) {
        String slug = this.generateUniqueSlug(user.getName(), UserType.SERVICE);
        return (InternalServiceUser)((InternalApplicationUser)super.create((Object)((InternalServiceUser.Builder)user.copy().slug(slug)).build())).accept((InternalStashUserVisitor)InternalServiceUser.TO_SERVICE_USER);
    }

    @Nonnull
    public InternalApplicationUser create(@Nonnull InternalApplicationUser user) {
        Objects.requireNonNull(user, "user");
        return (InternalApplicationUser)user.accept((InternalStashUserVisitor)new InternalStashUserVisitor<InternalApplicationUser>(){

            public InternalApplicationUser visit(@Nonnull InternalNormalUser user) {
                return HibernateApplicationUserDao.this.create(user);
            }

            public InternalApplicationUser visit(@Nonnull InternalServiceUser user) {
                return HibernateApplicationUserDao.this.create(user);
            }
        });
    }

    @Nonnull
    public Page<InternalApplicationUser> findAll(@Nonnull PageRequest pageRequest) {
        return this.findAll(UserType.NORMAL, pageRequest);
    }

    @Nonnull
    public Page<InternalApplicationUser> findAll(@Nonnull UserType userType, @Nonnull PageRequest pageRequest) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(this.userClassForType(userType)).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{this.orderFor(userType)});
        if (userType == UserType.SERVICE) {
            queryBuilder.where(HqlQueryBuilder.HqlWhereQueryComponent.equal((String)FIELD_ACTIVE, (Object)true));
        }
        return this.pageQuery(queryBuilder.buildQuery(this.session(), InternalApplicationUser.class), pageRequest);
    }

    @Nonnull
    public Page<InternalApplicationUser> findAll(@Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalApplicationUser> predicate) {
        return this.findAll(UserType.NORMAL, pageRequest, predicate);
    }

    @Nonnull
    public Page<InternalApplicationUser> findAll(@Nonnull UserType userType, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalApplicationUser> predicate) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(this.userClassForType(userType)).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{this.orderFor(userType)});
        return this.pageQuery(queryBuilder.buildQuery(this.session(), InternalApplicationUser.class), pageRequest, predicate);
    }

    public InternalNormalUser findByName(@Nonnull String username) {
        return (InternalNormalUser)this.session().createQuery("from InternalNormalUser where username = :username", InternalNormalUser.class).setParameter(FIELD_USERNAME, (Object)IdentifierUtils.toLowerCase((String)Objects.requireNonNull(username, FIELD_USERNAME))).uniqueResult();
    }

    public InternalNormalUser findBySlug(@Nonnull String slug) {
        return (InternalNormalUser)this.session().createQuery("from InternalNormalUser where slug = :slug", InternalNormalUser.class).setParameter(FIELD_SLUG, (Object)IdentifierUtils.toLowerCase((String)Objects.requireNonNull(slug, FIELD_SLUG))).uniqueResult();
    }

    @Nonnull
    public Set<InternalNormalUser> findByNames(@Nonnull Set<String> usernames) {
        Objects.requireNonNull(usernames, "usernames");
        if (usernames.isEmpty()) {
            return Collections.emptySet();
        }
        String hql = "from InternalNormalUser where username in (:usernames) order by username";
        Query query = this.session().createQuery(hql, InternalNormalUser.class).setParameterList("usernames", (Collection)usernames.stream().map(IdentifierUtils::toLowerCase).collect(MoreCollectors.toImmutableSet()));
        return ImmutableSet.copyOf((Collection)query.list());
    }

    public InternalServiceUser findServiceUserByName(@Nonnull String username, boolean inactive) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(InternalServiceUser.class);
        HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)FIELD_USERNAME, (Object)username)});
        if (!inactive) {
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)FIELD_ACTIVE, (Object)true)});
        }
        queryBuilder.where((HqlQueryBuilder.HqlWhereQueryComponent)HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{ands}));
        return (InternalServiceUser)queryBuilder.buildQuery(this.session()).uniqueResult();
    }

    @Nonnull
    public Page<InternalServiceUser> findServiceUsersByDisplayName(String displayName, @Nonnull PageRequest pageRequest) {
        Query query;
        if (StringUtils.isBlank((CharSequence)displayName)) {
            query = this.session().createQuery("from InternalServiceUser where active = true order by displayName", InternalServiceUser.class);
        } else {
            String hql = "from InternalServiceUser where active = true and lower(displayName) like :displayName order by displayName";
            query = this.session().createQuery(hql, InternalServiceUser.class).setParameter(FIELD_DISPLAY_NAME, (Object)("%" + IdentifierUtils.toLowerCase((String)displayName) + "%"));
        }
        return this.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Set<InternalServiceUser> findServiceUsersByName(@Nonnull Set<String> usernames) {
        Objects.requireNonNull(usernames, "usernames");
        if (usernames.isEmpty()) {
            return Collections.emptySet();
        }
        String hql = "from InternalServiceUser where username in (:usernames) order by username";
        Query query = this.session().createQuery(hql, InternalServiceUser.class).setParameterList("usernames", (Collection)usernames.stream().map(IdentifierUtils::toLowerCase).collect(MoreCollectors.toImmutableSet()));
        return ImmutableSet.copyOf((Collection)query.list());
    }

    public InternalServiceUser findServiceUserBySlug(@Nonnull String slug) {
        String hql = "from InternalServiceUser where slug = :slug and active = true";
        return (InternalServiceUser)this.session().createQuery(hql, InternalServiceUser.class).setParameter(FIELD_SLUG, (Object)slug).uniqueResult();
    }

    @Nonnull
    public Page<InternalNormalUser> findByDeletedDateEarlierThan(@Nonnull Date date, @Nonnull PageRequest pageRequest) {
        String hql = "from InternalNormalUser where deletedDate is not null and deletedDate < :deletedDate order by username";
        Query query = this.session().createQuery(hql, InternalNormalUser.class).setParameter(FIELD_DELETED_DATE, (Object)date);
        return this.pageQuery(query, pageRequest);
    }

    public InternalNormalUser loadUser(@Nonnull User user) {
        String hql = "select id, slug, locale, timeZone, deletedDate from InternalNormalUser where username = :username";
        Object[] result = (Object[])this.session().createQuery(hql, Object[].class).setParameter(FIELD_USERNAME, (Object)IdentifierUtils.toLowerCase((String)user.getName())).uniqueResult();
        if (result == null) {
            return null;
        }
        int id = ((Number)result[0]).intValue();
        String slug = (String)result[1];
        Locale locale = (Locale)result[2];
        ZoneId timeZone = (ZoneId)result[3];
        Date date = (Date)result[4];
        return ((InternalNormalUser.Builder)((InternalNormalUser.Builder)((InternalNormalUser.Builder)new InternalNormalUser.Builder().crowdUser(user).id(id)).locale(locale).name(user.getName())).slug(slug)).timeZone(timeZone).deletedDate(date).build();
    }

    @Nonnull
    public <T extends User> Set<InternalNormalUser> loadUsers(@Nonnull Iterable<T> users) {
        ImmutableMap usersByName = Maps.uniqueIndex(users, user -> IdentifierUtils.toLowerCase((String)user.getName()));
        if (usersByName.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<InternalNormalUser> normalUsers = new HashSet<InternalNormalUser>(usersByName.size(), 1.0f);
        for (List usernamePartition : Iterables.partition(usersByName.keySet(), (int)200)) {
            String hql = "select username, id, slug, locale, timeZone, deletedDate from InternalNormalUser where username in :usernames";
            List results = this.session().createQuery(hql, Object[].class).setParameterList("usernames", (Collection)usernamePartition).list();
            for (Object result : results) {
                Object[] columns = (Object[])result;
                normalUsers.add(((InternalNormalUser.Builder)((InternalNormalUser.Builder)((InternalNormalUser.Builder)new InternalNormalUser.Builder().crowdUser((User)usersByName.get(columns[0])).id(((Number)columns[1]).intValue())).name((String)columns[0])).slug((String)columns[2])).locale((Locale)columns[3]).timeZone((ZoneId)columns[4]).deletedDate((Date)columns[5]).build());
            }
        }
        return normalUsers;
    }

    public InternalNormalUser rename(@Nonnull String oldUsername, @Nonnull String newUsername) {
        InternalNormalUser user = this.findByName(oldUsername);
        if (user == null) {
            return null;
        }
        return (InternalNormalUser)this.update(((InternalNormalUser.Builder)((InternalNormalUser.Builder)user.copy().name(newUsername)).slug(this.generateUniqueSlugForUser(newUsername, user.getType(), (InternalApplicationUser)user))).build());
    }

    public InternalServiceUser update(@Nonnull InternalServiceUser user) {
        return (InternalServiceUser)this.session().merge((Object)user);
    }

    @Nonnull
    public InternalNormalUser createFor(@Nonnull User crowdUser) {
        InternalNormalUser user = this.findByName(crowdUser.getName());
        if (user == null) {
            user = this.create(((InternalNormalUser.Builder)new InternalNormalUser.Builder().name(crowdUser.getName())).crowdUser(crowdUser).build());
            this.session().saveOrUpdate((Object)new InternalUserSettings.Builder().user((InternalApplicationUser)user).settings(this.initialUserSettings).build());
        } else if (user.getDeletedDate() != null) {
            this.update(user.copy().deletedDate(null).build());
        }
        return user;
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    private String generateUniqueSlug(String username, UserType userType) {
        return this.generateUniqueSlugForUser(username, userType, null);
    }

    private String generateUniqueSlugForUser(String username, UserType userType, InternalApplicationUser user) {
        String initialSlug = InternalApplicationUser.slugify((String)username);
        Object slug = initialSlug;
        boolean slugFound = false;
        for (int tries = 0; tries <= 10; ++tries) {
            if (this.isSlugFree((String)slug, userType, user)) {
                log.debug("{}: Using slug \"{}\"", (Object)username, slug);
                slugFound = true;
                break;
            }
            log.debug("{}: Collision detected for slug \"{}\"", (Object)username, slug);
            slug = initialSlug + tries;
        }
        if (!slugFound) {
            slug = InternalApplicationUser.generateSlug((SecureTokenGenerator)this.tokenGenerator);
            log.debug("{}: Using random token \"{}\" as slug", (Object)username, slug);
        }
        return slug;
    }

    private boolean isSlugFree(String slug, UserType userType, InternalApplicationUser user) {
        InternalServiceUser slugUser = userType == UserType.SERVICE ? this.findServiceUserBySlug(slug) : this.findBySlug(slug);
        return slugUser == null || user != null && slugUser.getId() == user.getId();
    }

    private String safeAppendSuffix(String username, int maxResultLength, String suffix) {
        return username.substring(0, Math.min(maxResultLength - suffix.length(), username.length())) + suffix;
    }

    private Class<? extends InternalApplicationUser> userClassForType(UserType userType) {
        return userType == UserType.NORMAL ? InternalNormalUser.class : InternalServiceUser.class;
    }

    private HqlQueryBuilder.HqlQueryOrder orderFor(UserType userType) {
        if (userType == UserType.NORMAL) {
            return HqlQueryBuilder.HqlQueryOrder.asc((String)FIELD_USERNAME);
        }
        return HqlQueryBuilder.HqlQueryOrder.asc((String)FIELD_DISPLAY_NAME);
    }
}

