/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.dmz.user.ScopedPermission;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.user.EffectivePermissionDao;
import com.atlassian.stash.internal.user.GroupPermissionCriteria;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalScopedPermission;
import com.atlassian.stash.internal.user.PermissionCriteria;
import com.atlassian.stash.internal.user.ResourcePermission;
import com.atlassian.stash.internal.user.UserPermissionCriteria;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@org.springframework.stereotype.Repository(value="effectivePermissionDao")
public class HibernateEffectivePermissionDao
extends AbstractHibernateDao<Long, InternalScopedPermission>
implements EffectivePermissionDao {
    private static final int GROUPS_BATCH_SIZE = 1000;
    private final int largeFetchSize;

    @Autowired
    public HibernateEffectivePermissionDao(SessionFactory sessionFactory, @Value(value="${hibernate.jdbc.large_fetch_size:100}") int largeFetchSize) {
        super(sessionFactory);
        this.largeFetchSize = largeFetchSize;
    }

    @Nonnull
    public List<ResourcePermission> findByGroup(@Nonnull String group) {
        String hql = "select new com.atlassian.stash.internal.user.SimpleResourcePermission(p.group, p.permission, p.project.id, p.repository.id, rp.id) from InternalScopedPermission p left join p.repository.project rp where p.user is null and p.group = :groupName order by p.id asc";
        return this.session().createQuery(hql, ResourcePermission.class).setParameter("groupName", (Object)IdentifierUtils.toLowerCase((String)group)).list();
    }

    @Nonnull
    public Map<String, List<ResourcePermission>> findByGroups(@Nonnull Iterable<String> groups) {
        if (Iterables.isEmpty(groups)) {
            return Collections.emptyMap();
        }
        Iterable batches = Iterables.partition(groups, (int)1000);
        String hql = "select new com.atlassian.stash.internal.user.SimpleResourcePermission(p.group, p.permission, p.project.id, p.repository.id,CASE TYPE(p) WHEN InternalRepositoryPermission THEN p.repository.project.id ELSE NULL END) from InternalScopedPermission p left join p.repository.project rp where p.user is null and p.group in (:groupNames)";
        HashMap<String, List<ResourcePermission>> permissionsByGroup = new HashMap<String, List<ResourcePermission>>();
        batches.forEach(batch -> {
            List permissions = this.session().createQuery(hql, ResourcePermission.class).setParameterList("groupNames", (Collection)IdentifierUtils.toLowerCase((Collection)batch)).setFetchSize(this.largeFetchSize).list();
            for (ResourcePermission permission : permissions) {
                permissionsByGroup.computeIfAbsent(permission.getGroup(), group -> new ArrayList()).add(permission);
            }
        });
        return permissionsByGroup;
    }

    @Nonnull
    public Map<String, List<ResourcePermission>> findAllByGroups() {
        String hql = "select new com.atlassian.stash.internal.user.SimpleResourcePermission(p.group, p.permission, p.project.id, p.repository.id,CASE TYPE(p) WHEN InternalRepositoryPermission THEN p.repository.project.id ELSE NULL END) from InternalScopedPermission p left join p.repository.project rp where p.user is null and p.group is not null";
        List permissions = this.session().createQuery(hql, ResourcePermission.class).setFetchSize(this.largeFetchSize).list();
        HashMap<String, List<ResourcePermission>> permissionsByGroup = new HashMap<String, List<ResourcePermission>>();
        for (ResourcePermission permission : permissions) {
            permissionsByGroup.computeIfAbsent(permission.getGroup(), group -> new ArrayList()).add(permission);
        }
        return permissionsByGroup;
    }

    @Nonnull
    public List<ResourcePermission> findByUserId(@Nonnull Integer userId) {
        String hql = "select new com.atlassian.stash.internal.user.SimpleResourcePermission(p.permission, p.project.id, p.repository.id, rp.id, p.user.id) from InternalScopedPermission p left join p.repository.project rp where p.user = :userId and p.group is null order by p.id asc";
        return this.session().createQuery(hql, ResourcePermission.class).setParameter("userId", (Object)userId, (Type)StandardBasicTypes.INTEGER).list();
    }

    @Nonnull
    public Map<Integer, List<ResourcePermission>> findByUsers(@Nonnull List<Integer> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List batches = Lists.partition(userIds, (int)100);
        String hql = "select new com.atlassian.stash.internal.user.SimpleResourcePermission(p.permission, p.project.id, p.repository.id, rp.id, p.user.id) from InternalScopedPermission p left join p.repository.project rp where p.user.id in (:userIds) and p.group is null order by p.id asc";
        return batches.stream().map(batch -> this.session().createQuery(hql, ResourcePermission.class).setParameterList("userIds", (Collection)batch, (Type)StandardBasicTypes.INTEGER).setFetchSize(this.largeFetchSize).list()).flatMap(Collection::stream).collect(Collectors.groupingBy(p -> p.getUserId()));
    }

    @Nonnull
    public Page<String> findGroups(@Nonnull Permission permission, @Nonnull PageRequest pageRequest) {
        HqlQueryBuilder builder = HqlQueryBuilder.selectDistinctPropertiesFrom(InternalGlobalPermission.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"group")}).where((HqlQueryBuilder.HqlWhereQueryComponent)HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"permission", (Collection)permission.getInheritingPermissions()), HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"user"), HqlQueryBuilder.HqlWhereQueryComponent.isNotNull((String)"group")})).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"group")});
        Query query = builder.buildQuery(this.session(), String.class).setCacheable(true).setCacheRegion("query.permissions");
        return this.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Page<ApplicationUser> findUsers(@Nonnull Permission permission, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super ApplicationUser> predicate) {
        HqlQueryBuilder subQueryBuilder = HqlQueryBuilder.selectDistinctPropertiesFrom(InternalGlobalPermission.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"user.id")}).where((HqlQueryBuilder.HqlWhereQueryComponent)HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"permission", (Collection)permission.getInheritingPermissions()), HqlQueryBuilder.HqlWhereQueryComponent.isNotNull((String)"user"), HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"group")}));
        HqlQueryBuilder builder = HqlQueryBuilder.selectFrom(InternalNormalUser.class).where(HqlQueryBuilder.HqlWhereQueryComponent.inSubQuery((String)"id", (HqlQueryBuilder)subQueryBuilder)).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"username")});
        return HibernatePageUtils.pageQuery((Query)builder.buildQuery(this.session(), ApplicationUser.class), (PageRequest)pageRequest, predicate);
    }

    public boolean isGrantedToGroup(@Nonnull GroupPermissionCriteria criteria) {
        Permission permission = criteria.getPermission();
        Set groups = criteria.getGroups();
        HqlQueryBuilder builder = HqlQueryBuilder.selectPropertiesFrom(InternalScopedPermission.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.rowCount((String)"id", InternalScopedPermission.class)});
        HibernateEffectivePermissionDao.maybeOuterJoinRepository((PermissionCriteria)criteria, (HqlQueryBuilder<InternalScopedPermission>)builder);
        HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"permission", (Collection)permission.getInheritingPermissions()), HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"user"), HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"group"), HqlQueryBuilder.HqlWhereQueryComponent.in((String)"group", (Collection)IdentifierUtils.toLowerCase((Collection)groups))})});
        HibernateEffectivePermissionDao.includeResourceIds((PermissionCriteria)criteria, conditionals);
        builder.where((HqlQueryBuilder.HqlWhereQueryComponent)conditionals);
        return (Long)builder.buildQuery(this.session(), Long.class).setCacheable(true).setCacheRegion("query.permissions").uniqueResult() > 0L;
    }

    public boolean isGrantedToUser(@Nonnull UserPermissionCriteria criteria) {
        Permission permission = criteria.getPermission();
        Integer userId = criteria.getUserId();
        HqlQueryBuilder builder = HqlQueryBuilder.selectPropertiesFrom(InternalScopedPermission.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.rowCount((String)"id", InternalScopedPermission.class)});
        HibernateEffectivePermissionDao.maybeOuterJoinRepository((PermissionCriteria)criteria, (HqlQueryBuilder<InternalScopedPermission>)builder);
        HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"permission", (Collection)permission.getInheritingPermissions()), HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"user"), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"user.id", (Object)userId)}), HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"group")});
        HibernateEffectivePermissionDao.includeResourceIds((PermissionCriteria)criteria, conditionals);
        builder.where((HqlQueryBuilder.HqlWhereQueryComponent)conditionals);
        return (Long)builder.buildQuery(this.session(), Long.class).uniqueResult() > 0L;
    }

    @Nonnull
    public Stream<ScopedPermission> streamGrantedPermissions() {
        String hql = "select new com.atlassian.stash.internal.user.SimpleScopedPermission(p) from InternalScopedPermission p left join p.user where p.group is not null or p.user.class <> InternalServiceUser order by coalesce(p.user.username, p.group) asc, p.id asc ";
        return this.streamQuery(this.session().createQuery(hql, ScopedPermission.class));
    }

    private static void includeResourceIds(PermissionCriteria criteria, HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals) {
        Permission permission = criteria.getPermission();
        Integer projectId = criteria.getProjectId();
        Integer repositoryId = criteria.getRepositoryId();
        if (permission.isGlobal()) {
            conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"project"), HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"repository")});
        } else if (permission.isResource(Project.class) && permission != Permission.PROJECT_VIEW) {
            conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"repository")});
            if (projectId != null) {
                conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"project"), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"project.id", (Object)projectId)})});
            }
        } else if (permission.isResource(Repository.class) || permission == Permission.PROJECT_VIEW) {
            if (projectId != null || repositoryId != null) {
                HqlQueryBuilder.HqlWhereConditionalQueryComponent or = HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
                or.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"project"), HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"repository")})});
                if (projectId != null) {
                    or.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"project.id", (Object)projectId)});
                }
                if (repositoryId != null) {
                    or.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"repository.id", (Object)repositoryId)});
                } else if (permission == Permission.PROJECT_VIEW) {
                    or.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"repository.project.id", (Object)projectId)});
                }
                conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{or});
            }
        } else {
            throw new IllegalArgumentException("Unsupported permission: " + String.valueOf(permission));
        }
    }

    private static void maybeOuterJoinRepository(PermissionCriteria criteria, HqlQueryBuilder<InternalScopedPermission> builder) {
        Permission permission = criteria.getPermission();
        Integer projectId = criteria.getProjectId();
        Integer repositoryId = criteria.getRepositoryId();
        if (permission == Permission.PROJECT_VIEW && (projectId != null || repositoryId == null)) {
            builder.join("repository", HqlQueryBuilder.JoinType.LEFT_OUTER_JOIN);
        }
    }

    private <T> Stream<T> streamQuery(Query<T> query) {
        return query.setCacheMode(CacheMode.IGNORE).setFetchSize(100).setMaxResults(0x7FFFFFFE).stream();
    }
}

