/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.PermittedGroup;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.user.AbstractHibernatePermissionDao;
import com.atlassian.stash.internal.user.GlobalPermissionDao;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalScopedPermission;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="grantedGlobalPermissionDao")
public class HibernateGlobalPermissionDao
extends AbstractHibernatePermissionDao<InternalGlobalPermission>
implements GlobalPermissionDao {
    @Autowired
    public HibernateGlobalPermissionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Page<String> findGroupsWithPermission(@Nonnull PageRequest pageRequest) {
        return super.findGroupsWithPermission(pageRequest, this.entityClass, null);
    }

    @Nonnull
    public Page<PermittedGroup> findHighestPermissionPerGroup(@Nullable String filter, @Nonnull PageRequest pageRequest) {
        return HibernatePageUtils.pageQuery(this.createFindHighestPermissionPerGroupQuery(filter, null), (PageRequest)pageRequest);
    }

    @Nonnull
    public Page<PermittedUser> findHighestPermissionPerUser(@Nonnull UserType userType, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        Page<ApplicationUser> page = this.findUsersWithPermission(userType, filter, pageRequest, this.entityClass, null);
        if (page.getIsLastPage() && page.getSize() == 0) {
            return HibernatePageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Query<Object[]> query = this.createFindHighestPermissionPerUserQuery(page, null);
        return this.pairUsersWithPermissions(page, query);
    }

    @Nonnull
    public Page<ApplicationUser> findUsersWithPermission(@Nonnull UserType userType, @Nonnull PageRequest request) {
        return this.findUsersWithPermission(userType, null, request, this.entityClass, null);
    }

    public int revoke(@Nonnull InternalGlobalPermission permission) {
        return this.createRevokeQuery((InternalScopedPermission)permission, null).executeUpdate();
    }
}

