/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.dmz.user.PermittedPrincipal;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalProjectSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalSearchRequest;
import com.atlassian.bitbucket.dmz.user.ProjectPermission;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermittedGroup;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.UserUtils;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.project.InternalProject_;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.user.AbstractHibernatePermissionDao;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.InternalProjectPermission_;
import com.atlassian.stash.internal.user.InternalScopedPermission;
import com.atlassian.stash.internal.user.PermittedPrincipalSearchQueryHelper;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.persistence.criteria.Expression;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="grantedProjectPermissionDao")
public class HibernateProjectPermissionDao
extends AbstractHibernatePermissionDao<InternalProjectPermission>
implements ProjectPermissionDao {
    private static final Set<Permission> projectPermissions = Arrays.stream(Permission.values()).filter(p -> p.isResource(Project.class)).collect(Collectors.toSet());

    @Autowired
    public HibernateProjectPermissionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Map<Permission, Long> countByPermissionForAllGroups() {
        String hql = "select permission, count(*) from InternalProjectPermission where user is null group by permission";
        return this.countByPermission((Query<Object[]>)this.session().createQuery(hql, Object[].class));
    }

    @Nonnull
    public Map<Permission, Long> countByPermissionForAllUsers() {
        String hql = "select permission, count(*) from InternalProjectPermission where group is null group by permission";
        return this.countByPermission((Query<Object[]>)this.session().createQuery(hql, Object[].class));
    }

    @Nonnull
    public Page<String> findGroupsWithPermission(int projectId, @Nonnull PageRequest pageRequest) {
        return this.findGroupsWithPermission(pageRequest, this.entityClass, this.whereIdEq(projectId));
    }

    @Nonnull
    public Page<PermittedGroup> findHighestPermissionPerGroup(int projectId, String filter, @Nonnull PageRequest pageRequest) {
        Query<PermittedGroup> query = this.createFindHighestPermissionPerGroupQuery(filter, (builder, permissionRoot) -> builder.equal((Expression)permissionRoot.get(InternalProjectPermission_.project).get(InternalProject_.id), (Object)projectId));
        return HibernatePageUtils.pageQuery(query, (PageRequest)pageRequest);
    }

    @Nonnull
    public Page<PermittedUser> findHighestPermissionPerUser(int projectId, @Nonnull UserType userType, String filter, @Nonnull PageRequest pageRequest) {
        Page<ApplicationUser> page = this.findUsersWithPermission(userType, filter, pageRequest, this.entityClass, this.whereIdEq(projectId));
        if (page.getIsLastPage() && page.getSize() == 0) {
            return HibernatePageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Query<Object[]> query = this.createFindHighestPermissionPerUserQuery(page, (builder, permissionRoot) -> builder.equal((Expression)permissionRoot.get(InternalProjectPermission_.project).get(InternalProject_.id), (Object)projectId));
        return this.pairUsersWithPermissions(page, query);
    }

    @Nonnull
    public Page<ProjectPermission> findHighestPermissionsForUser(int userId, @Nonnull PageRequest pageRequest) {
        String hql = "select new com.atlassian.stash.internal.user.InternalGrantedProjectPermission(pj, max(t.weight)) from InternalProjectPermission p, InternalPermissionType t, InternalProject pj where p.permission = t.id and p.project.id = pj.id and p.group is null and p.user.id = :userId group by pj.id, pj.name order by pj.name";
        Query query = this.session().createQuery(hql, ProjectPermission.class).setParameter("userId", (Object)userId, (Type)StandardBasicTypes.INTEGER);
        return HibernateUtils.initializePage((Page)HibernatePageUtils.pageQuery((Query)query, (PageRequest)pageRequest));
    }

    @Nonnull
    public Page<PermittedPrincipal> findPrincipalsWithAccess(@Nonnull PermittedPrincipalProjectSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Query<PermittedPrincipal> query = new PermittedPrincipalSearchQueryHelper(this.session(), (PermittedPrincipalSearchRequest)searchRequest).build();
        return HibernateUtils.initializePage((Page)(searchRequest.getName().isPresent() ? HibernatePageUtils.pageQuery(query, (PageRequest)pageRequest, HibernateProjectPermissionDao.nameFilter((String)searchRequest.getName().get())) : HibernatePageUtils.pageQuery(query, (PageRequest)pageRequest)));
    }

    @Nonnull
    public Page<ApplicationUser> findUsersWithPermission(int projectId, @Nonnull UserType userType, @Nonnull PageRequest pageRequest) {
        return this.findUsersWithPermission(userType, null, pageRequest, this.entityClass, this.whereIdEq(projectId));
    }

    @Nonnull
    public Map<Integer, Permission> getDefaultPermissions() {
        Query query = this.session().createQuery("select p.project.id, max(t.weight) from InternalProjectPermission p, InternalPermissionType t where p.group is null and p.user is null and t.id = p.permission group by p.project", Object[].class);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.scrollQuery(query, result -> builder.put((Object)result.getInteger(0), (Object)Permission.fromWeight((int)result.getInteger(1))));
        return builder.build();
    }

    public Permission getHighestDefaultPermission(int projectId) {
        String hql = "select max(t.weight) from InternalProjectPermission p, InternalPermissionType t where p.permission = t.id and p.project.id = :projectId and p.group is null and p.user is null ";
        Query query = this.session().createQuery(hql, Integer.class).setParameter("projectId", (Object)projectId, (Type)StandardBasicTypes.INTEGER);
        Integer maxWeight = (Integer)query.uniqueResult();
        return maxWeight == null ? null : Permission.fromWeight((int)maxWeight);
    }

    public Permission getHighestPermissionForUser(int userId, int projectId) {
        String hql = "select max(t.weight) from InternalProjectPermission p, InternalPermissionType t where p.permission = t.id and p.project.id = :projectId and p.group is null and p.user.id = :userId";
        Query query = this.session().createQuery(hql, Integer.class).setParameter("userId", (Object)userId, (Type)StandardBasicTypes.INTEGER).setParameter("projectId", (Object)projectId, (Type)StandardBasicTypes.INTEGER);
        Integer maxWeight = (Integer)query.uniqueResult();
        return maxWeight == null ? null : Permission.fromWeight((int)maxWeight);
    }

    public boolean isGrantedToUser(int userId, int projectId, @Nonnull Permission permission) {
        Objects.requireNonNull(permission, "permission");
        Preconditions.checkArgument((boolean)permission.isResource(Project.class), (String)"%s is not a project permission", (Object)permission);
        String hql = "select count(*) from InternalProjectPermission where user.id = :userId and project.id = :projectId and permission = :permission";
        Query query = this.session().createQuery(hql, Long.class).setParameter("projectId", (Object)projectId, (Type)StandardBasicTypes.INTEGER).setParameter("userId", (Object)userId, (Type)StandardBasicTypes.INTEGER).setParameter("permission", (Object)permission);
        return (Long)query.uniqueResult() > 0L;
    }

    public int revoke(@Nonnull InternalProjectPermission permission) {
        return this.createRevokeQuery((InternalScopedPermission)permission, "project.id = :projectId").setParameter("projectId", (Object)permission.getProject().getId(), (Type)StandardBasicTypes.INTEGER).executeUpdate();
    }

    private static Predicate<PermittedPrincipal> nameFilter(String filter) {
        Pattern pattern = UserUtils.createNameMatchingPattern((String)filter);
        return principal -> {
            if (principal.getGroup().isPresent()) {
                return pattern.matcher((CharSequence)principal.getGroup().get()).find();
            }
            if (principal.getUser().isPresent()) {
                ApplicationUser user = (ApplicationUser)principal.getUser().get();
                return pattern.matcher(user.getName()).find() || pattern.matcher(user.getDisplayName()).find() || StringUtils.isNotBlank((CharSequence)user.getEmailAddress()) && pattern.matcher(user.getEmailAddress()).find();
            }
            return true;
        };
    }

    @Override
    protected HqlQueryBuilder.HqlWhereQueryComponent createHasPermissionConditions(InternalProjectPermission permission) {
        HqlQueryBuilder.HqlWhereQueryComponent whereQueryComponent = super.createHasPermissionConditions(permission);
        return HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{whereQueryComponent, HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"project", (Object)permission.getProject())});
    }

    private Map<Permission, Long> countByPermission(Query<Object[]> query) {
        EnumMap<Permission, Long> countsByPermission = new EnumMap<Permission, Long>(Permission.class);
        for (Object[] column : query.list()) {
            countsByPermission.put((Permission)column[0], (Long)column[1]);
        }
        ImmutableMap.Builder countsByPermissionBuilder = ImmutableMap.builder();
        for (Permission permission : projectPermissions) {
            countsByPermissionBuilder.put((Object)permission, (Object)countsByPermission.getOrDefault(permission, 0L));
        }
        return countsByPermissionBuilder.build();
    }

    private HqlQueryBuilder.HqlWhereQueryComponent whereIdEq(int projectId) {
        return HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"project.id", (Object)projectId);
    }
}

