/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalRepositoryAccess;
import com.atlassian.stash.internal.user.RepositoryAccessDao;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryAccessDao")
public class HibernateRepositoryAccessDao
extends AbstractHibernateDao<InternalRepositoryAccess.PK, InternalRepositoryAccess>
implements RepositoryAccessDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.desc((String)"lastAccessed"));

    @Autowired
    public HibernateRepositoryAccessDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteAllAccessesForRepository(int repositoryId) {
        return this.session().createQuery("delete from InternalRepositoryAccess where repository.id = :repositoryId").setParameter("repositoryId", (Object)repositoryId).executeUpdate();
    }

    public int deleteAllAccessesForUser(int userId) {
        return this.session().createQuery("delete from InternalRepositoryAccess where user.id = :userId").setParameter("userId", (Object)userId).executeUpdate();
    }

    public Page<InternalRepository> findRecentRepositories(int userId, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        Query query = HqlQueryBuilder.selectPropertiesFrom(InternalRepositoryAccess.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"repository")}).where(HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"user.id", (Object)userId)).orderBy(IMPLICIT_QUERY_ORDER).buildQuery(this.session(), InternalRepository.class);
        return HibernateUtils.initializePage((Page)HibernatePageUtils.pageQuery((Query)query, (PageRequest)pageRequest, predicate));
    }

    public void trimRecentRepositories(int userId, int pageLimit) {
        Query query = HqlQueryBuilder.selectFrom(InternalRepositoryAccess.class).where(HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"user.id", (Object)userId)).orderBy(IMPLICIT_QUERY_ORDER).buildQuery(this.session());
        Page repoAccesses = this.pageQuery(query, HibernatePageUtils.newRequest((int)0, (int)pageLimit));
        if (!repoAccesses.getIsLastPage() && repoAccesses.getSize() > 0) {
            long lastAccessed = ((InternalRepositoryAccess)Iterables.getLast((Iterable)repoAccesses.getValues())).getLastAccessed().getTime();
            this.session().createQuery("delete InternalRepositoryAccess where user.id = :userId and lastAccessed < :minLastAccessed").setParameter("userId", (Object)userId).setParameter("minLastAccessed", (Object)lastAccessed).executeUpdate();
        }
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

