/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.dmz.user.PermittedPrincipal;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalRepositorySearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalSearchRequest;
import com.atlassian.bitbucket.dmz.user.RepositoryPermission;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermittedGroup;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.UserUtils;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository_;
import com.atlassian.stash.internal.user.AbstractHibernatePermissionDao;
import com.atlassian.stash.internal.user.InternalRepositoryPermission;
import com.atlassian.stash.internal.user.InternalRepositoryPermission_;
import com.atlassian.stash.internal.user.InternalScopedPermission;
import com.atlassian.stash.internal.user.PartitionedGroups;
import com.atlassian.stash.internal.user.PermittedPrincipalSearchQueryHelper;
import com.atlassian.stash.internal.user.RepositoryPermissionDao;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.Expression;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Repository(value="grantedRepositoryPermissionDao")
public class HibernateRepositoryPermissionDao
extends AbstractHibernatePermissionDao<InternalRepositoryPermission>
implements RepositoryPermissionDao {
    @Autowired
    public HibernateRepositoryPermissionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long countWithPermission(int userId, @Nonnull PartitionedGroups allGroups, int projectId) {
        Iterator i = allGroups.iterator();
        List first = (List)i.next();
        if (i.hasNext()) {
            HashSet ids = Sets.newHashSet();
            ids.addAll(this.getRepositoriesWithPermission(userId, first, projectId));
            while (i.hasNext()) {
                Collection groups = (Collection)i.next();
                ids.addAll(this.getRepositoriesWithPermission(userId, groups, projectId));
            }
            return ids.size();
        }
        return this.countRepositoriesWithPermission(userId, first, projectId);
    }

    @Nonnull
    public Page<String> findGroupsWithPermission(int repositoryId, @Nonnull PageRequest pageRequest) {
        return this.findGroupsWithPermission(pageRequest, this.entityClass, HibernateRepositoryPermissionDao.whereIdEq(repositoryId));
    }

    @Nonnull
    public Page<PermittedGroup> findHighestPermissionPerGroup(int repositoryId, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        Query<PermittedGroup> query = this.createFindHighestPermissionPerGroupQuery(filter, (builder, permissionRoot) -> builder.equal((Expression)permissionRoot.get(InternalRepositoryPermission_.repository).get(InternalRepository_.id), (Object)repositoryId));
        return HibernatePageUtils.pageQuery(query, (PageRequest)pageRequest);
    }

    @Nonnull
    public Page<PermittedUser> findHighestPermissionPerUser(int repositoryId, @Nonnull UserType userType, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        Page<ApplicationUser> page = this.findUsersWithPermission(userType, filter, pageRequest, this.entityClass, HibernateRepositoryPermissionDao.whereIdEq(repositoryId));
        if (page.getIsLastPage() && page.getSize() == 0) {
            return HibernatePageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Query<Object[]> query = this.createFindHighestPermissionPerUserQuery(page, (builder, permissionRoot) -> builder.equal((Expression)permissionRoot.get(InternalRepositoryPermission_.repository).get(InternalRepository_.id), (Object)repositoryId));
        return this.pairUsersWithPermissions(page, query);
    }

    @Nonnull
    public Page<RepositoryPermission> findHighestPermissionsForUser(int userId, @Nonnull PageRequest pageRequest) {
        String hql = "select new com.atlassian.stash.internal.user.InternalGrantedRepositoryPermission(r, max(t.weight)) from InternalRepositoryPermission p, InternalPermissionType t, InternalRepository r, InternalProject pj where p.permission = t.id and p.repository.id = r.id and r.project.id = pj.id and p.group is null and p.user.id = :userId group by r.id, pj.name, r.name order by pj.name, r.name";
        Query query = this.session().createQuery(hql, RepositoryPermission.class).setParameter("userId", (Object)userId);
        return HibernateUtils.initializePage((Page)HibernatePageUtils.pageQuery((Query)query, (PageRequest)pageRequest));
    }

    @Nonnull
    public Page<PermittedPrincipal> findPrincipalsWithAccess(@Nonnull PermittedPrincipalRepositorySearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Query<PermittedPrincipal> query = new PermittedPrincipalSearchQueryHelper(this.session(), (PermittedPrincipalSearchRequest)searchRequest).build();
        return HibernateUtils.initializePage((Page)(searchRequest.getName().isPresent() ? HibernatePageUtils.pageQuery(query, (PageRequest)pageRequest, HibernateRepositoryPermissionDao.nameFilter((String)searchRequest.getName().get())) : HibernatePageUtils.pageQuery(query, (PageRequest)pageRequest)));
    }

    @Nonnull
    public Page<ApplicationUser> findUsersWithPermission(int repositoryId, @Nonnull UserType userType, @Nonnull PageRequest pageRequest) {
        return this.findUsersWithPermission(userType, null, pageRequest, this.entityClass, HibernateRepositoryPermissionDao.whereIdEq(repositoryId));
    }

    @Nullable
    public Permission getHighestPermissionForUser(int userId, int repositoryId) {
        String hql = "select max(t.weight) from InternalRepositoryPermission p, InternalPermissionType t where p.permission = t.id and p.repository.id = :repositoryId and p.group is null and p.user.id = :userId";
        Query query = this.session().createQuery(hql, Integer.class).setParameter("userId", (Object)userId).setParameter("repositoryId", (Object)repositoryId);
        Integer maxWeight = (Integer)query.uniqueResult();
        return maxWeight == null ? null : Permission.fromWeight((int)maxWeight);
    }

    public int revoke(@Nonnull InternalRepositoryPermission permission) {
        return this.createRevokeQuery((InternalScopedPermission)permission, "repository.id = :repositoryId").setParameter("repositoryId", (Object)permission.getRepository().getId(), (Type)StandardBasicTypes.INTEGER).executeUpdate();
    }

    @Override
    protected HqlQueryBuilder.HqlWhereQueryComponent createHasPermissionConditions(InternalRepositoryPermission permission) {
        HqlQueryBuilder.HqlWhereQueryComponent whereQueryComponent = super.createHasPermissionConditions(permission);
        return HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{whereQueryComponent, HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"repository", (Object)permission.getRepository())});
    }

    private static HqlQueryBuilder.HqlWhereQueryComponent createRepositoriesWithPermissionCondition(int userId, Collection<String> groups, int projectId) {
        return HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"permission", (Collection)Permission.getPermissionsOn(Repository.class)), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"repository.project.id", (Object)projectId), HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"user.id", (Object)userId), HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"group")}), HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"user"), HqlQueryBuilder.HqlWhereQueryComponent.in((String)"group", groups)})})});
    }

    private static Predicate<PermittedPrincipal> nameFilter(String filter) {
        Pattern pattern = UserUtils.createNameMatchingPattern((String)filter);
        return principal -> {
            if (principal.getGroup().isPresent()) {
                return pattern.matcher((CharSequence)principal.getGroup().get()).find();
            }
            if (principal.getUser().isPresent()) {
                ApplicationUser user = (ApplicationUser)principal.getUser().get();
                return pattern.matcher(user.getName()).find() || pattern.matcher(user.getDisplayName()).find() || StringUtils.isNotBlank((CharSequence)user.getEmailAddress()) && pattern.matcher(user.getEmailAddress()).find();
            }
            return true;
        };
    }

    private static HqlQueryBuilder.HqlWhereQueryComponent whereIdEq(int repositoryId) {
        return HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"repository.id", (Object)repositoryId);
    }

    private long countRepositoriesWithPermission(int userId, Collection<String> groups, int projectId) {
        return (Long)HqlQueryBuilder.selectPropertiesFrom((Class)this.entityClass, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.distinctRowCount((String)"repository.id")}).where(HibernateRepositoryPermissionDao.createRepositoriesWithPermissionCondition(userId, groups, projectId)).buildQuery(this.session(), Long.class).uniqueResult();
    }

    private List<Integer> getRepositoriesWithPermission(int userId, Collection<String> groups, int projectId) {
        return HqlQueryBuilder.selectDistinctPropertiesFrom((Class)this.entityClass, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"repository.id")}).where(HibernateRepositoryPermissionDao.createRepositoriesWithPermissionCondition(userId, groups, projectId)).buildQuery(this.session(), Integer.class).list();
    }
}

